set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4013',
      '11132200',
      '41242041',
      '12312134',
      '22312443',
      '03241200',
      '11213303',
      '10234143',
      '31234404',
      '02330323',
      '41143124',
      '02224341',
      NULL,
      '03421033',
      NULL,
      NULL,
      NULL,
      NULL,
      '30243324',
      '22232133',
      '24223234',
      '31432120',
      '33034122',
      '31001013',
      '02314140',
      '21211021',
      '44033312',
      '00221022',
      '44332201',
      '42233423',
      '31242422',
      '12031122',
      '12231021',
      '11432141',
      '24342414',
      '30240244',
      '11433244',
      '31241141',
      NULL,
      NULL,
      NULL,
      '40213204',
      '21134022',
      '23141321',
      '00020004',
      '',
      '',
      NULL,
      NULL,
      '4003301',
      0.602464,
      41.296525,
      3,
      NULL,
      '324330',
      2.551557,
      ' 1- 4-2000',
      ' 2-16-1993',
      49,
      NULL,
      3,
      3,
      8,
      NULL,
      7.045806,
      4.044491,
      NULL,
      4.006454,
      5,
      0.105859,
      9,
      21.911652,
      19.329161,
      14.091228,
      10,
      7.962525,
      NULL,
      NULL,
      NULL,
      11.642884,
      35.059865,
      NULL,
      NULL,
      98.251241,
      101.653483,
      16.864180,
      47,
      102,
      150.741783,
      ' 9-11-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.491749,
      0.343918,
      2.981597,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.452106,
      2.321691,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-14-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5- 5-1977',
      117.677500,
      63,
      53,
      70,
      62,
      75.281650,
      61.561068,
      109,
      100,
      NULL,
      131.513758,
      NULL,
      ' 1- 1-1987',
      6.174361,
      21,
      13,
      20.932651,
      58.679192,
      8.433503,
      5.595987,
      ' 4- 2-1998',
      NULL,
      20,
      ' 1-19-1987',
      3,
      5.428480,
      NULL,
      4,
      3.247428,
      4.965909,
      NULL,
      9,
      NULL,
      5.705434,
      5,
      7.769262,
      7.728228,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.504219,
      40.662767,
      56.193763,
      NULL,
      0.976049,
      62.213749,
      '10-15-1978',
      3,
      NULL,
      8.846396,
      35.133937,
      ' 3-10-2003',
      65.041182,
      0.795446,
      105,
      ' 1-23-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      99,
      NULL,
      41,
      16.285969,
      NULL,
      NULL,
      1,
      7.145813,
      2,
      13,
      73.083097,
      1,
      1,
      103,
      0,
      3.992904,
      14.063134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51,
      15.607732,
      67.713801,
      1.739153,
      14,
      1.577498,
      NULL,
      0.966137,
      2.232715,
      0.519135,
      1,
      NULL,
      18.070029,
      2.228192,
      6.457131,
      79.320016,
      65,
      1.263241,
      1,
      NULL,
      NULL,
      NULL,
      0.309626,
      NULL,
      NULL,
      49,
      NULL,
      13,
      1,
      6.677790,
      NULL,
      28,
      NULL,
      7,
      68.314613,
      NULL,
      17,
      49,
      10.747173,
      NULL,
      1,
      4,
      0.174119,
      1.007725,
      0.528789,
      2,
      34.017073,
      ' 7-16-1990',
      ' 3-22-2003',
      ' 5- 2-1982',
      NULL,
      ' 8- 2-2000',
      '11- 8-1993',
      NULL,
      NULL);
commit;
end;
/


