set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3000',
      '21332024',
      NULL,
      '00204232',
      '00332344',
      '13143222',
      '22313433',
      '02034403',
      '03400023',
      '32130134',
      '20013410',
      '14402141',
      '14334003',
      '24100101',
      '01414023',
      '22110030',
      '03301123',
      '24200434',
      '22143414',
      '24020201',
      '03410211',
      '20123300',
      '20234241',
      '42222220',
      '02324222',
      NULL,
      NULL,
      '20213242',
      '11011041',
      '41433042',
      '22110103',
      '00343433',
      '23111423',
      '30033223',
      '22232111',
      NULL,
      '33231102',
      '23140423',
      NULL,
      '04302033',
      '31122344',
      '42102140',
      '42431310',
      NULL,
      '02202243',
      '202',
      '11',
      NULL,
      NULL,
      '1244034',
      3,
      20.108349,
      1,
      NULL,
      '224144',
      4.856850,
      ' 3-10-1997',
      ' 5-20-1999',
      18,
      NULL,
      2.964058,
      3.589662,
      NULL,
      10,
      11,
      9,
      4,
      14.407071,
      3,
      19,
      17.122565,
      0.712274,
      31.619247,
      13,
      2,
      3,
      67.423063,
      14,
      39,
      NULL,
      13,
      2,
      2.984462,
      59,
      NULL,
      63,
      154,
      NULL,
      169,
      '10- 8-1974',
      5.893009,
      49,
      6.036707,
      22,
      20.901552,
      NULL,
      ' 6- 0-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.005889,
      32,
      6,
      14.155512,
      7.197503,
      2.879817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      16,
      26.535813,
      90,
      46.584795,
      NULL,
      102,
      1.637527,
      57.611835,
      87,
      69,
      ' 3-18-1975',
      27,
      14,
      12,
      21,
      64,
      40,
      10.645807,
      '10-23-1995',
      17,
      21.769244,
      ' 7- 4-1974',
      5.669903,
      9,
      9.892691,
      7,
      10.055213,
      3,
      3.508963,
      NULL,
      0,
      41.111618,
      1.034677,
      1,
      5,
      10,
      0,
      2.936244,
      NULL,
      NULL,
      ' 7-16-1991',
      2.370434,
      0,
      NULL,
      ' 8-18-1993',
      146,
      NULL,
      '10-17-1998',
      NULL,
      NULL,
      NULL,
      47,
      ' 6-25-1994',
      1.673454,
      ' 2- 5-1979',
      9,
      8,
      ' 2-15-1995',
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      ' 1-22-1994',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      19.942359,
      ' 6- 7-1983',
      NULL,
      37,
      3.991860,
      NULL,
      1,
      NULL,
      ' 6-25-1988',
      NULL,
      120,
      0,
      43,
      NULL,
      27.942248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


