set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1420',
      NULL,
      NULL,
      '12002103',
      '44014140',
      '13324214',
      '13121041',
      '33013101',
      '33113201',
      '43230224',
      '21323043',
      '12304221',
      '44311412',
      '04233112',
      '32422220',
      '32400402',
      NULL,
      NULL,
      '24123041',
      NULL,
      '33424033',
      NULL,
      '22214444',
      '13041130',
      '23023213',
      '21110220',
      '41010000',
      '04102121',
      '23144241',
      '31443243',
      '01143130',
      '20223142',
      '01222123',
      NULL,
      NULL,
      '31334233',
      '11400201',
      '33103031',
      '23231000',
      '40044321',
      '44134122',
      '32022033',
      '44402024',
      '33321122',
      NULL,
      '244',
      '10',
      44.362202,
      6.363425,
      '3414443',
      3,
      155,
      1,
      NULL,
      NULL,
      4.220547,
      ' 7- 3-1983',
      ' 3- 9-1991',
      39.439045,
      143.351116,
      7.418438,
      9,
      18.501930,
      4,
      29,
      10.487172,
      NULL,
      6,
      19.063295,
      NULL,
      36,
      7.035986,
      20.753384,
      14.415050,
      NULL,
      9.415417,
      71,
      1,
      3,
      5.409950,
      9,
      4,
      NULL,
      29,
      NULL,
      30,
      16.101240,
      149,
      51.908508,
      ' 7-26-2000',
      16.193721,
      39,
      NULL,
      25.913162,
      36,
      190.281978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      14,
      5.894998,
      7,
      9,
      ' 6-19-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.966178,
      34.771920,
      2,
      15.875806,
      NULL,
      NULL,
      62,
      57.591715,
      43.587173,
      13,
      36,
      NULL,
      ' 7- 1-1998',
      12.231686,
      6.132999,
      13.822176,
      NULL,
      34.052125,
      NULL,
      2.570533,
      NULL,
      21,
      NULL,
      ' 9-22-1995',
      NULL,
      8.737026,
      12.323242,
      NULL,
      3.397876,
      NULL,
      0.523517,
      1.567450,
      1,
      46,
      NULL,
      0.195142,
      3,
      26.067293,
      0.187536,
      7,
      NULL,
      1,
      ' 4-12-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      11.527583,
      10,
      ' 4- 3-1979',
      NULL,
      NULL,
      NULL,
      47.777432,
      NULL,
      36,
      NULL,
      NULL,
      9.496051,
      ' 7- 7-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      13.458246,
      '11-19-1978',
      NULL,
      40.256056,
      25.625508,
      ' 1-29-1980',
      NULL,
      87,
      '10-21-1998',
      11,
      155.068620,
      17,
      25,
      ' 2-18-1992',
      41,
      0.893664,
      136.612283,
      ' 2- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


