set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      '4',
      '0',
      '4',
      '2',
      '2',
      '2',
      '2',
      '0',
      '2',
      NULL,
      NULL,
      '4',
      '0',
      '3',
      '2',
      '3',
      '3',
      NULL,
      '2',
      '3',
      '2',
      '4',
      '',
      '2',
      '',
      '1',
      '3',
      '4',
      NULL,
      '1',
      '',
      NULL,
      '2',
      NULL,
      '2',
      '0',
      '1',
      '2',
      '0',
      '2',
      '4',
      '4',
      '3',
      '311',
      '22144101',
      37,
      8.264548,
      '0240130',
      2.513264,
      228,
      1,
      NULL,
      NULL,
      NULL,
      ' 1-17-1999',
      ' 6-24-1995',
      96.495010,
      23.227019,
      NULL,
      13.288516,
      11.120623,
      3.960939,
      1,
      7,
      NULL,
      NULL,
      20.266241,
      10,
      5,
      8,
      18.695090,
      NULL,
      14.003416,
      7.833845,
      39,
      11.057915,
      NULL,
      6,
      2,
      0,
      0,
      34.922017,
      146,
      27,
      185,
      6,
      NULL,
      '11-19-1982',
      20,
      13.066856,
      9,
      8.052282,
      NULL,
      134.312291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25.744854,
      NULL,
      28.627302,
      11,
      8,
      1.809074,
      ' 0- 2-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      108.233961,
      88.785560,
      15.518847,
      53.387177,
      NULL,
      87,
      68.511720,
      92,
      25,
      25,
      7,
      45.828495,
      ' 3-21-2002',
      22,
      2,
      22.243414,
      16.261328,
      67.686268,
      82,
      8.223577,
      NULL,
      18.669844,
      4,
      NULL,
      NULL,
      7.295447,
      10,
      16,
      2.530711,
      4.043132,
      1.426156,
      13.227986,
      NULL,
      23.895895,
      0,
      1,
      8.532646,
      29.994340,
      0.485649,
      8,
      0.420654,
      0,
      ' 0-12-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-1987',
      17,
      ' 3-20-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.549512,
      ' 4-21-1985',
      4.414268,
      36.890107,
      42,
      ' 0- 2-1977',
      1.407512,
      39.199774,
      ' 2-23-2001',
      2.149321,
      81.431019,
      NULL,
      28.962306,
      '11-22-1988',
      NULL,
      1,
      71,
      ' 7-16-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


