set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6902795';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '3',
      '3',
      '1',
      NULL,
      '3',
      '3',
      NULL,
      '2',
      '1',
      '3',
      NULL,
      NULL,
      NULL,
      '3',
      '1',
      '2',
      '2',
      '1',
      '1',
      '1',
      '4',
      '4',
      '',
      '2',
      '',
      '2',
      '1',
      '1',
      '1',
      '2',
      '',
      '',
      '2',
      '0',
      '3',
      '2',
      '3',
      '1',
      '1',
      NULL,
      '1',
      NULL,
      '0',
      NULL,
      '30330410',
      27.326922,
      34.912482,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '100413',
      NULL,
      ' 3-21-2001',
      '11-11-1986',
      NULL,
      NULL,
      NULL,
      5,
      3,
      6,
      NULL,
      11,
      10.137386,
      1,
      NULL,
      12,
      44,
      13,
      4,
      1,
      NULL,
      0,
      28.081693,
      3,
      30,
      14.582013,
      46.100914,
      5.531107,
      1,
      41.366206,
      NULL,
      NULL,
      19.599540,
      41,
      8,
      ' 8- 7-1989',
      19,
      9.658045,
      11.485546,
      NULL,
      NULL,
      NULL,
      ' 7-15-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      27.604894,
      10,
      23.830551,
      11,
      1,
      '11-28-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      25,
      NULL,
      52,
      68,
      51.102325,
      69,
      28,
      46.897930,
      51,
      10,
      5.519912,
      ' 2-29-1979',
      2.701166,
      9.028047,
      8.099313,
      NULL,
      54.973310,
      23.654738,
      NULL,
      ' 2-28-2001',
      11,
      12.448604,
      NULL,
      2.302282,
      1,
      10,
      3.183476,
      NULL,
      1.194852,
      1,
      NULL,
      1,
      13,
      5.312512,
      0.478099,
      NULL,
      12,
      0,
      0,
      1,
      1.462388,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      NULL,
      '10- 3-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 1-1979',
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      ' 8-14-1979',
      5,
      24,
      35.292325,
      ' 1-20-1977',
      NULL,
      77.047574,
      '11- 4-1991',
      5.778493,
      40,
      NULL,
      NULL,
      ' 8-27-2000',
      22.436508,
      1,
      183.322162,
      ' 6- 8-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


