set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9114150';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '12013243',
      '10124231',
      NULL,
      '10013044',
      '42030330',
      '32033133',
      NULL,
      '41410044',
      '31321202',
      '40203314',
      '20010030',
      NULL,
      '12244401',
      '00310431',
      '04012322',
      '32112341',
      '01231103',
      '14403344',
      '00432223',
      '01102300',
      NULL,
      '33131132',
      '34232033',
      '40120222',
      '02342333',
      '42241203',
      NULL,
      '13243341',
      '11234410',
      '01140042',
      '33343101',
      '43214203',
      '20144300',
      '10444243',
      '34124241',
      '24134144',
      '32314020',
      '01141033',
      NULL,
      '13030013',
      '43134243',
      '11010120',
      '11212111',
      '33033223',
      '302',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.335913,
      2,
      NULL,
      '223313',
      NULL,
      ' 0-27-1975',
      '10-26-1986',
      7.940528,
      NULL,
      6,
      17.149247,
      4.802802,
      8,
      9.930837,
      18,
      24.729880,
      3,
      27,
      19.119820,
      37,
      25,
      0.739550,
      13,
      5.599717,
      2,
      14,
      18,
      NULL,
      5,
      42,
      20,
      1,
      NULL,
      125.744010,
      NULL,
      199.213288,
      69.508340,
      138,
      ' 1- 2-1997',
      3.878155,
      41,
      NULL,
      17.427150,
      104.175223,
      186.249271,
      NULL,
      2,
      2,
      0.446375,
      2.713642,
      1,
      0.254120,
      NULL,
      1,
      0,
      NULL,
      7,
      0.724925,
      1.275315,
      0.167407,
      NULL,
      0.504823,
      NULL,
      1,
      1.945665,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-18-1985',
      34,
      2.281282,
      5.971948,
      5.894392,
      5,
      8,
      ' 9-19-1989',
      NULL,
      NULL,
      157,
      NULL,
      1.224686,
      20,
      0.032133,
      1.167037,
      40.844828,
      0.562733,
      0,
      2,
      NULL,
      131.617338,
      137.132967,
      109.703681,
      113.165496,
      85.779166,
      44.495896,
      62.321609,
      20.227142,
      NULL,
      24,
      NULL,
      65.702467,
      ' 3- 4-1986',
      25,
      NULL,
      29,
      12.061983,
      29,
      142,
      13,
      ' 0-10-2000',
      11,
      5,
      ' 9-20-1978',
      NULL,
      14,
      5,
      11,
      NULL,
      3,
      NULL,
      20,
      0,
      74,
      0,
      17,
      8.801179,
      1.477059,
      0,
      1.313184,
      0.037007,
      1.840422,
      ' 9-19-1977',
      NULL,
      3,
      0,
      ' 7-11-1996',
      125,
      20,
      ' 5-27-2000',
      34,
      13,
      NULL,
      12.775803,
      ' 4-22-1999',
      32.489190,
      ' 3- 6-1991',
      8.576689,
      9.339895,
      ' 0-17-2001',
      39,
      55,
      ' 7- 0-2001',
      14.708896,
      NULL,
      ' 9-12-1980',
      0.964320,
      0,
      ' 8- 3-1993',
      NULL,
      2,
      NULL,
      NULL,
      42.371506,
      1,
      NULL,
      ' 5- 8-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.368823);
commit;
end;
/


