set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9654423';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '0',
      '2',
      '1',
      '1',
      '2',
      '0',
      '4',
      '0',
      '3',
      '4',
      '0',
      '4',
      '3',
      '2',
      '0',
      '2',
      '2',
      '4',
      '1',
      '2',
      NULL,
      '3',
      '0',
      '',
      '1',
      '',
      NULL,
      '1',
      '1',
      '2',
      '3',
      '',
      '',
      '2',
      '3',
      '3',
      '2',
      '2',
      NULL,
      '4',
      '2',
      '3',
      NULL,
      '2',
      '220',
      '11233031',
      0,
      72,
      NULL,
      0.483015,
      NULL,
      NULL,
      1,
      '012012',
      5.469172,
      ' 4- 0-1985',
      ' 7-26-1991',
      48,
      273,
      19.269535,
      NULL,
      13.125321,
      NULL,
      NULL,
      23,
      13.653713,
      27,
      7,
      15,
      11.917547,
      NULL,
      17.069805,
      NULL,
      13,
      3.919851,
      NULL,
      14.141217,
      29,
      0.559744,
      44,
      NULL,
      0.386786,
      42,
      56,
      51,
      142,
      NULL,
      18.465698,
      ' 5- 5-1976',
      49,
      42.862617,
      4,
      16,
      164,
      100,
      ' 3-22-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.100245,
      11.645219,
      0,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      61.325673,
      1.796852,
      1,
      69,
      NULL,
      0,
      71.426697,
      NULL,
      NULL,
      NULL,
      ' 9-13-2001',
      25.499325,
      NULL,
      5.979120,
      30,
      20.096675,
      NULL,
      NULL,
      27,
      50,
      NULL,
      44.988222,
      32,
      ' 2-17-1994',
      20,
      3,
      6,
      NULL,
      NULL,
      151.224694,
      NULL,
      ' 0- 0-1999',
      25.159256,
      19.935282,
      ' 6-22-1975',
      6.044704,
      NULL,
      6.352797,
      12.091875,
      24,
      8.189268,
      1,
      13,
      1,
      7.790250,
      1,
      1,
      NULL,
      17,
      1,
      NULL,
      0.605145,
      0.498922,
      ' 1-22-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      38.313455,
      NULL,
      ' 9-18-2002',
      NULL,
      NULL,
      NULL,
      36,
      ' 0-22-1995',
      24.684141,
      ' 5- 7-1976',
      4,
      1,
      ' 5-10-1984',
      122,
      121,
      ' 4-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      23,
      ' 4- 3-1992',
      NULL,
      28.881724,
      17,
      ' 0- 2-1990',
      1,
      127.276128,
      ' 0-13-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


