set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9829832';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      '1',
      '4',
      '0',
      '0',
      '3',
      '3',
      '2',
      '4',
      '3',
      NULL,
      '3',
      '4',
      '4',
      '2',
      '0',
      '2',
      '1',
      '4',
      '0',
      '2',
      '1',
      '0',
      '',
      NULL,
      '',
      '4',
      '3',
      '4',
      '2',
      '2',
      '',
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      '0',
      '1',
      '0',
      '1',
      NULL,
      '4',
      NULL,
      '421',
      '24144203',
      77.801817,
      77,
      '1133113',
      3.748799,
      1,
      NULL,
      0,
      '213442',
      2,
      ' 4- 5-2001',
      ' 4-28-1992',
      NULL,
      121,
      NULL,
      8,
      6,
      31,
      83.830312,
      3.259976,
      20,
      NULL,
      20,
      3,
      24,
      27,
      18,
      NULL,
      9,
      27,
      67,
      18,
      25,
      18,
      126,
      NULL,
      0,
      74,
      164,
      18.060610,
      60.834019,
      93,
      258.999509,
      NULL,
      13,
      31,
      14.875127,
      7,
      NULL,
      NULL,
      ' 2-17-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      17.418101,
      1.287351,
      0.420644,
      2.925126,
      6,
      ' 3- 6-2001',
      3.760825,
      1.642259,
      29,
      1.574100,
      0,
      NULL,
      0,
      NULL,
      117.519735,
      NULL,
      NULL,
      NULL,
      ' 8-12-1992',
      16,
      41.974392,
      57,
      59,
      NULL,
      NULL,
      14,
      70,
      61.429548,
      33.725650,
      19.873909,
      75,
      ' 2-23-1976',
      NULL,
      20.836167,
      16,
      27.876747,
      41.253564,
      62,
      8.832761,
      '11- 5-1978',
      2,
      20,
      ' 8-13-1987',
      NULL,
      12,
      15,
      2,
      7.797598,
      NULL,
      NULL,
      16,
      0.635979,
      86.181736,
      1.136920,
      0,
      11,
      2.384889,
      0.284991,
      1.875205,
      NULL,
      0,
      ' 6-26-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      83,
      1,
      ' 0- 6-1995',
      NULL,
      NULL,
      NULL,
      44.720103,
      '10- 7-1996',
      NULL,
      ' 4-27-1993',
      7.428411,
      5.286065,
      ' 0-21-1998',
      136.187392,
      35.476572,
      ' 4-12-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      ' 4-11-1986',
      61,
      9,
      46.160371,
      NULL,
      0.531262,
      105.670443,
      ' 7-26-1994',
      8,
      17,
      10,
      25,
      ' 2-16-1977',
      20,
      1,
      86.381692,
      ' 9-11-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


