set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9830316';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      NULL,
      NULL,
      '4',
      '1',
      '4',
      '3',
      '1',
      '0',
      '4',
      '3',
      NULL,
      '4',
      NULL,
      '2',
      '4',
      '1',
      '4',
      '1',
      '3',
      '2',
      '0',
      '2',
      NULL,
      '0',
      '',
      '1',
      '4',
      '4',
      '3',
      '3',
      NULL,
      '',
      '1',
      '3',
      '3',
      '3',
      '0',
      '0',
      NULL,
      NULL,
      '0',
      NULL,
      '1',
      '403',
      '21112220',
      44.940273,
      10.515037,
      '3304322',
      3.933935,
      NULL,
      2,
      0,
      '444224',
      0.583359,
      ' 0- 7-1995',
      ' 2-12-2003',
      32,
      47.837926,
      5.438843,
      12,
      2.661859,
      7.454366,
      38,
      6,
      10,
      NULL,
      13,
      11,
      26,
      1.803013,
      23,
      4.779978,
      NULL,
      0,
      5,
      5.850056,
      8,
      11.254267,
      70,
      6.235740,
      0.608682,
      73,
      4.737953,
      NULL,
      102.796153,
      31.969140,
      114.916312,
      '10-14-1982',
      49,
      3,
      35.288423,
      15.280086,
      150,
      169,
      ' 9-22-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41.863514,
      NULL,
      11.491760,
      3.897615,
      25.540315,
      5.915616,
      NULL,
      1.981435,
      0,
      146,
      3.396437,
      1.559624,
      NULL,
      1.255996,
      0.044678,
      80.698783,
      NULL,
      NULL,
      NULL,
      ' 1-29-2001',
      43,
      17.284591,
      NULL,
      80.502802,
      6,
      53.609849,
      46.048165,
      45.944654,
      NULL,
      36,
      3,
      NULL,
      ' 7-27-1999',
      2,
      12.858472,
      13,
      24,
      NULL,
      9,
      8.149374,
      ' 6-21-1994',
      2,
      17,
      '11- 9-1989',
      NULL,
      NULL,
      8.757952,
      NULL,
      25.404988,
      NULL,
      NULL,
      13.411884,
      0.737920,
      41.010264,
      0,
      1,
      24.475415,
      NULL,
      0,
      NULL,
      0,
      0.632636,
      ' 8-14-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      ' 8-25-1998',
      NULL,
      NULL,
      NULL,
      44.109548,
      NULL,
      14.684771,
      NULL,
      NULL,
      16.913271,
      ' 1-23-1996',
      89,
      78.263441,
      '11- 9-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      ' 6- 8-1994',
      32,
      19,
      11,
      ' 0-11-1984',
      NULL,
      98.753852,
      ' 5-22-1993',
      1,
      23.107734,
      6,
      17.997009,
      ' 5- 4-2001',
      NULL,
      0,
      140.128892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


