set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2204',
      '30032242',
      NULL,
      '30341242',
      '11304310',
      '02423433',
      NULL,
      '31042430',
      NULL,
      '43411123',
      NULL,
      '22231011',
      '14431323',
      '43322422',
      NULL,
      '14230041',
      NULL,
      NULL,
      '34023304',
      '40411130',
      '12443312',
      '42230422',
      '34333304',
      NULL,
      NULL,
      '20042334',
      '44313114',
      '03244431',
      '22341133',
      NULL,
      '04211123',
      '40032430',
      NULL,
      '01002221',
      '43333222',
      '11433011',
      '30231441',
      NULL,
      NULL,
      '22441143',
      '13322412',
      '34323404',
      '31120010',
      '33211310',
      '01413343',
      '',
      '',
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      '404104',
      0.170569,
      NULL,
      NULL,
      4.152169,
      NULL,
      4,
      18.397671,
      8.324474,
      25.943203,
      NULL,
      6,
      28,
      27,
      27,
      3,
      0,
      NULL,
      0.954932,
      1.835616,
      3.844312,
      18,
      47,
      NULL,
      NULL,
      NULL,
      NULL,
      13.683501,
      NULL,
      127,
      159,
      29,
      NULL,
      27.053336,
      103.315924,
      NULL,
      NULL,
      35,
      30,
      14.592582,
      13,
      207,
      ' 2-15-1990',
      1.921252,
      0,
      0.149385,
      1.590403,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449992,
      1.099506,
      3.445964,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-21-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 1-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.719336,
      ' 3-24-1986',
      23,
      7.192086,
      10,
      NULL,
      32,
      62,
      10.734862,
      ' 6- 1-1992',
      34,
      32.845016,
      NULL,
      NULL,
      3,
      17,
      NULL,
      28,
      NULL,
      NULL,
      25.692794,
      NULL,
      34,
      0,
      16,
      8.082740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-16-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46.154463,
      8.210695,
      1.330515,
      NULL,
      1.106087,
      NULL,
      ' 3- 5-1981',
      NULL,
      1.605403,
      14,
      29,
      ' 1-19-1994',
      23.066756,
      0,
      62,
      ' 4-19-1997',
      NULL,
      NULL,
      NULL,
      99.956537,
      60.847261,
      NULL,
      21.698989,
      15,
      25,
      NULL,
      NULL,
      25,
      4.647977,
      12.460830,
      NULL,
      0.201905,
      0.393729,
      47.277072,
      1.948996,
      NULL,
      65,
      0,
      1,
      92.816648,
      NULL,
      0.480412,
      3.835007,
      NULL,
      32,
      NULL,
      1,
      101.184628,
      NULL,
      1.723162,
      0,
      1.619118,
      NULL,
      1,
      63,
      49,
      NULL,
      17,
      74,
      67.232203,
      0,
      0,
      44,
      NULL,
      2,
      NULL,
      30,
      0.470345,
      53,
      1.455674,
      NULL,
      0,
      6,
      42.167764,
      NULL,
      NULL,
      18.180506,
      94,
      17,
      22,
      96,
      14.332330,
      1,
      NULL,
      NULL,
      1,
      0,
      1.510110,
      NULL,
      NULL,
      ' 6- 9-1990',
      ' 1-12-1986',
      ' 5-23-1994',
      '11-26-1999',
      '10-29-1981',
      ' 7-20-1978',
      ' 8-29-1977',
      NULL);
commit;
end;
/


