set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0340',
      '33143344',
      '23120434',
      '30131303',
      NULL,
      '43302043',
      '42411314',
      '24423121',
      NULL,
      NULL,
      '43220424',
      '11121031',
      '13120133',
      '40020113',
      '43431310',
      '34303131',
      '40144311',
      NULL,
      '20140222',
      NULL,
      '13301211',
      NULL,
      '13242104',
      '33432001',
      '10141333',
      '13143044',
      '42210033',
      '30402000',
      '44443132',
      NULL,
      NULL,
      '32310442',
      '41420034',
      NULL,
      '00042022',
      '23212213',
      '13242303',
      NULL,
      '04203114',
      '03133103',
      '33321303',
      '23331141',
      NULL,
      NULL,
      '10312431',
      '',
      '',
      NULL,
      NULL,
      '4424102',
      3,
      NULL,
      NULL,
      NULL,
      '431302',
      1,
      ' 5-12-1979',
      ' 5-10-1992',
      4.023035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      27.350987,
      8.798580,
      3.030300,
      97,
      64.514329,
      ' 1-15-1986',
      0.164760,
      3.637392,
      3,
      0.212428,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.266131,
      1,
      1,
      0.717103,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 9-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      127.546205,
      56.952136,
      110,
      121,
      81,
      NULL,
      134,
      NULL,
      NULL,
      107.368875,
      135.844985,
      NULL,
      NULL,
      22,
      NULL,
      2,
      61.372634,
      43.175593,
      NULL,
      6,
      ' 4- 2-1984',
      0.677894,
      8,
      ' 5-19-1998',
      11.585765,
      10.625002,
      NULL,
      0.043583,
      3.069044,
      NULL,
      NULL,
      4,
      NULL,
      104,
      NULL,
      5.441286,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.354556,
      20,
      '10-23-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66,
      84.829160,
      129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.287588,
      1.200888,
      0,
      NULL,
      38,
      0.348759,
      3.784123,
      62.442587,
      2.271373,
      1.872901,
      73.401860,
      87,
      NULL,
      NULL,
      1.933698,
      39,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29,
      NULL,
      NULL,
      NULL,
      32,
      1.516026,
      0,
      52,
      0,
      1.782385,
      0.283165,
      NULL,
      NULL,
      64,
      NULL,
      131.270208,
      1,
      2.536865,
      NULL,
      13.106187,
      1,
      36.046010,
      59,
      NULL,
      NULL,
      NULL,
      10.805085,
      0.913180,
      NULL,
      1,
      NULL,
      0.556994,
      0,
      1.992621,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4- 5-1998',
      ' 3-10-1978',
      NULL,
      ' 3- 5-1977',
      NULL);
commit;
end;
/


