set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9021970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34123040',
      '30110012',
      '23220343',
      '11022210',
      '43441244',
      '20142110',
      '20401202',
      '43140140',
      NULL,
      '13222431',
      '33233434',
      '42144410',
      '04232040',
      '11312400',
      '01202411',
      '12130232',
      '33340303',
      '23111122',
      '10204300',
      '23411034',
      '11113423',
      '21213112',
      '13113433',
      '10032301',
      '23222402',
      '11330304',
      '31232134',
      '14333311',
      '32224021',
      '40241413',
      '24444012',
      '30110334',
      NULL,
      '41100322',
      '30324300',
      '10243303',
      '33244241',
      NULL,
      '00123130',
      '41303233',
      '30223242',
      '23330301',
      '40303011',
      '20203144',
      '',
      '',
      NULL,
      NULL,
      '2302200',
      NULL,
      0,
      1,
      NULL,
      '113221',
      NULL,
      '10-27-1980',
      ' 4-19-2003',
      96,
      NULL,
      NULL,
      3.733560,
      1,
      13.423062,
      69,
      16,
      11.328385,
      NULL,
      27.577076,
      NULL,
      NULL,
      NULL,
      32,
      NULL,
      5,
      7.386480,
      NULL,
      17.910441,
      60.959396,
      17.676406,
      63,
      NULL,
      NULL,
      83.438022,
      NULL,
      62.473760,
      108.845358,
      70,
      1.034071,
      ' 7- 2-1981',
      NULL,
      37,
      9.888273,
      26.837498,
      104,
      100,
      ' 7-18-1987',
      0.216282,
      0.466706,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.910793,
      0,
      0.712587,
      1.901532,
      0.176267,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-12-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-12-1975',
      85.834727,
      75.149457,
      NULL,
      78.036438,
      84,
      105.988806,
      39,
      16.694779,
      79,
      31.662487,
      11.014443,
      21,
      ' 4-27-1993',
      25.319873,
      3.115774,
      24,
      49.571524,
      28.254947,
      NULL,
      NULL,
      ' 9- 2-1981',
      17.291333,
      8.480852,
      ' 9-19-1995',
      8.938193,
      NULL,
      3.543830,
      NULL,
      5.482231,
      10,
      NULL,
      1,
      NULL,
      116.572618,
      2,
      2.993264,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 9-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      16,
      ' 7-23-1994',
      1.348732,
      33,
      ' 0-27-1977',
      14.280868,
      43.155257,
      18.941365,
      5,
      ' 3- 0-1996',
      27,
      1,
      124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      156,
      1.319811,
      NULL,
      84,
      127,
      55,
      0,
      14,
      NULL,
      9,
      NULL,
      1.129258,
      0,
      43.920636,
      NULL,
      NULL,
      NULL,
      1,
      3,
      66,
      0.900993,
      2.679805,
      96.009103,
      15.566355,
      NULL,
      61.171494,
      0.508594,
      58,
      NULL,
      0.721217,
      1.540056,
      NULL,
      NULL,
      1,
      41.654502,
      6.437690,
      84,
      10,
      98.640838,
      73,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.786981,
      32,
      1,
      1.888035,
      NULL,
      3.970994,
      10,
      2,
      17.491748,
      83.253451,
      NULL,
      NULL,
      11.250559,
      2,
      NULL,
      3,
      0,
      NULL,
      1,
      NULL,
      26.184258,
      ' 0-20-1980',
      ' 8- 0-1998',
      ' 7-26-1986',
      NULL,
      ' 0- 4-1987',
      NULL,
      '10-15-1987',
      NULL);
commit;
end;
/


