set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8119304';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '1',
      '2',
      NULL,
      '2',
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      '0',
      '3',
      '3',
      '2',
      '2',
      NULL,
      '',
      '3',
      '',
      '4',
      '3',
      '1',
      '3',
      '3',
      '',
      '',
      '0',
      '1',
      '0',
      '2',
      NULL,
      '1',
      '3',
      '4',
      '2',
      NULL,
      NULL,
      NULL,
      '14141414',
      3,
      25.064708,
      '1242340',
      1.112653,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      ' 8-21-1987',
      107.014575,
      105,
      18.338241,
      NULL,
      10.130840,
      3,
      25.944297,
      18.575042,
      15,
      0,
      13,
      11,
      11,
      NULL,
      20.667656,
      13,
      11.300440,
      8.626597,
      73.780004,
      NULL,
      56,
      6.908455,
      24.291390,
      12.272572,
      0,
      8,
      112.704868,
      NULL,
      181,
      151,
      15.439288,
      ' 6-12-2000',
      26.220358,
      12,
      26,
      29.382964,
      12,
      196,
      ' 7-28-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68.518386,
      22.280046,
      8.789168,
      7,
      NULL,
      7.091347,
      ' 7-15-1998',
      6,
      1.095177,
      93.232157,
      NULL,
      3,
      59.057534,
      5,
      1,
      11,
      NULL,
      NULL,
      NULL,
      ' 2-27-1975',
      NULL,
      46,
      98,
      85.617338,
      77.221059,
      53.715700,
      90,
      NULL,
      NULL,
      25.384053,
      23.572131,
      13,
      ' 1-27-1981',
      4.394870,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      11.792085,
      NULL,
      3.532476,
      3.083128,
      ' 9- 2-2001',
      9.945553,
      5.763382,
      13,
      NULL,
      6,
      14.997599,
      NULL,
      2,
      0.602726,
      56,
      8,
      NULL,
      11.667227,
      6,
      0.772467,
      NULL,
      6,
      1.873172,
      ' 4-29-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      126.024392,
      3.979005,
      ' 4-18-1987',
      NULL,
      NULL,
      NULL,
      25,
      ' 6-22-1995',
      49.255586,
      ' 1- 8-1987',
      9,
      9,
      ' 6- 7-1975',
      125,
      73,
      ' 1- 2-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      14.321938,
      '11-19-1986',
      44.682217,
      15.300972,
      29,
      NULL,
      3.113760,
      NULL,
      '10-27-1979',
      9,
      11.678062,
      NULL,
      56,
      '11- 7-1994',
      36.723377,
      1.115014,
      40,
      ' 3- 8-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


