set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8203810';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3401',
      '32224224',
      '41340000',
      '04041244',
      '30132034',
      NULL,
      '12124032',
      '43101130',
      '34213243',
      '03432033',
      NULL,
      '20413102',
      '02422104',
      '34110033',
      '23321331',
      '30210131',
      '11104124',
      '11423422',
      '23002120',
      '42101120',
      NULL,
      '34443410',
      '40432344',
      '23400133',
      '04204040',
      NULL,
      '44303123',
      '43000114',
      '12404304',
      '12332412',
      '20201312',
      NULL,
      '11444014',
      '14341414',
      NULL,
      NULL,
      '04331341',
      NULL,
      '14220001',
      '41200030',
      '34332412',
      '30032123',
      '21112340',
      '41030303',
      '30002030',
      '',
      '',
      NULL,
      NULL,
      '4331332',
      NULL,
      0.370296,
      NULL,
      NULL,
      '233312',
      NULL,
      ' 3-10-1994',
      NULL,
      52,
      NULL,
      2.405087,
      1.723103,
      11.209980,
      19,
      NULL,
      28,
      11,
      24.797464,
      31.583164,
      18.876284,
      43.837490,
      15.627560,
      NULL,
      20,
      10.005767,
      1,
      70.302575,
      26.462053,
      NULL,
      9,
      6.994539,
      NULL,
      NULL,
      86.483651,
      95.034574,
      122,
      204,
      89.296232,
      NULL,
      ' 3-12-1994',
      NULL,
      NULL,
      12,
      17,
      203.408972,
      68,
      ' 5-15-2002',
      1,
      1,
      1,
      3.716125,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442240,
      0.949369,
      NULL,
      1.863803,
      1,
      2.472908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-15-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-26-1988',
      84.945312,
      NULL,
      91.622713,
      NULL,
      120.188987,
      2,
      111,
      88,
      NULL,
      82.583168,
      43,
      85.339765,
      ' 5-19-1974',
      1,
      0,
      5,
      75,
      5.542615,
      121.829278,
      6,
      ' 9-24-1996',
      28.881628,
      9.153556,
      ' 7-10-1997',
      4,
      14,
      12,
      16,
      17.783455,
      NULL,
      NULL,
      8.043579,
      NULL,
      81,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 3-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.751694,
      41,
      11,
      NULL,
      NULL,
      123.009578,
      '10- 1-2003',
      6,
      NULL,
      8.362503,
      23,
      ' 8-21-1998',
      56,
      NULL,
      NULL,
      ' 6- 6-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      45.717953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.122292,
      27,
      1,
      0.244090,
      59,
      1.316857,
      0.034995,
      134,
      1.791850,
      4.055042,
      59.459134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.510541,
      1.801608,
      0,
      1.518057,
      0.472423,
      NULL,
      NULL,
      NULL,
      9.582630,
      NULL,
      NULL,
      9,
      1,
      1.976113,
      0.083330,
      2,
      0,
      14.104806,
      1,
      NULL,
      3,
      NULL,
      1.453636,
      1.825124,
      NULL,
      NULL,
      12.275973,
      16,
      NULL,
      NULL,
      14.720973,
      NULL,
      17.680392,
      0.390911,
      1.976683,
      1.047468,
      0.478290,
      3,
      1,
      0,
      NULL,
      NULL,
      ' 1-10-1998',
      NULL,
      ' 3- 2-1988',
      ' 0-18-1998',
      '11- 2-1995',
      ' 8-23-1998',
      NULL);
commit;
end;
/


