set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7837080';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31033333',
      '23411131',
      '31001033',
      '40342443',
      '43030223',
      '13302431',
      '43200100',
      '34430302',
      '21010022',
      '00432303',
      '21300314',
      '21132431',
      NULL,
      '03013142',
      NULL,
      NULL,
      '11121122',
      '01403200',
      '41410141',
      '43014304',
      '14330411',
      NULL,
      '00030201',
      '23442420',
      '23010024',
      '43334433',
      '20312401',
      '23341334',
      '14323110',
      '13111112',
      '43241114',
      NULL,
      '02200200',
      '03230042',
      '33143120',
      '02030321',
      '14100141',
      NULL,
      '24013244',
      '02213341',
      '43111312',
      '02213441',
      '30021002',
      '00333004',
      '124',
      '04',
      16,
      1.221443,
      '3243221',
      2,
      1.893092,
      1,
      NULL,
      '310341',
      4.749197,
      ' 3-23-1999',
      ' 8- 4-1978',
      NULL,
      17.790061,
      4,
      0.355640,
      17,
      NULL,
      58,
      25.314094,
      14.767750,
      24.952866,
      31.831431,
      7,
      36,
      19.805207,
      1.889157,
      3.212914,
      5.400548,
      8.126903,
      24,
      2,
      5.721401,
      22.996610,
      43,
      17,
      0.389347,
      74.945005,
      239.355191,
      35.457037,
      97.808355,
      162,
      175,
      '10-11-1988',
      71,
      51.414611,
      NULL,
      26,
      NULL,
      109,
      '11-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.808275,
      1,
      7,
      ' 1- 5-1993',
      0,
      1.759608,
      232,
      0,
      NULL,
      NULL,
      NULL,
      1,
      11.720791,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      71,
      30,
      90,
      103,
      17,
      NULL,
      51,
      46,
      26.859575,
      78,
      NULL,
      ' 4-18-1993',
      20,
      5,
      6,
      0,
      43.603859,
      33,
      13.807669,
      NULL,
      NULL,
      NULL,
      ' 6-24-1988',
      6.319075,
      16.858736,
      NULL,
      19.563577,
      16.283959,
      8.155619,
      2.537896,
      12.179628,
      NULL,
      69,
      5.266131,
      4.291788,
      16.384088,
      23,
      3.306610,
      0.964482,
      0.493566,
      1,
      ' 9- 2-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      187.452589,
      13.709449,
      ' 4-17-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 7-1984',
      NULL,
      NULL,
      7,
      12,
      ' 9-14-1993',
      35.401930,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      6.124660,
      ' 7- 8-2002',
      28.618762,
      29,
      45,
      ' 4- 5-1993',
      NULL,
      NULL,
      '11-24-1980',
      3,
      14.320962,
      16.600151,
      17.118180,
      ' 4-22-1984',
      60,
      0,
      102.596176,
      ' 2-24-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


