set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7837080';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      NULL,
      '2',
      '2',
      '3',
      '0',
      '2',
      '3',
      '2',
      '3',
      '2',
      NULL,
      NULL,
      '3',
      '3',
      '3',
      '2',
      '3',
      '0',
      NULL,
      '1',
      '0',
      '4',
      '',
      NULL,
      '',
      '4',
      '0',
      '3',
      NULL,
      '3',
      '',
      '',
      '4',
      '3',
      '0',
      '1',
      '0',
      '2',
      NULL,
      '2',
      NULL,
      '0',
      NULL,
      '402',
      '22',
      28,
      3.605153,
      '1024011',
      0,
      24,
      3,
      NULL,
      NULL,
      3.226469,
      NULL,
      ' 6-14-1989',
      35.061019,
      NULL,
      30,
      24.890596,
      0.176632,
      NULL,
      102,
      NULL,
      3.659352,
      2,
      27.088582,
      17.425164,
      52.227967,
      NULL,
      37.319409,
      16,
      34.488303,
      14.816708,
      70.525031,
      2.089616,
      67.309297,
      NULL,
      49,
      6.228910,
      NULL,
      8.268536,
      NULL,
      NULL,
      207,
      69.974124,
      9,
      '11- 4-1992',
      54.792169,
      11,
      22.087939,
      34,
      NULL,
      167.691659,
      ' 4-24-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.826744,
      2.539384,
      27,
      6,
      NULL,
      2.658651,
      ' 4-11-1993',
      0.032584,
      1,
      31.402856,
      0.524832,
      NULL,
      131,
      1.145239,
      0,
      48,
      NULL,
      NULL,
      NULL,
      ' 6- 8-1993',
      NULL,
      51.733924,
      119.381441,
      3,
      5.517936,
      7,
      56.493942,
      33.856429,
      43,
      102,
      NULL,
      104,
      ' 4-13-1976',
      22,
      NULL,
      16,
      28.235170,
      NULL,
      NULL,
      4.082501,
      NULL,
      20,
      1,
      ' 2-23-2002',
      2.562773,
      NULL,
      14.489758,
      NULL,
      12.900202,
      6.726975,
      1,
      12,
      0,
      9,
      NULL,
      0,
      8.355537,
      22.014060,
      0.573754,
      0,
      NULL,
      1.569248,
      ' 9-14-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      218,
      14.253903,
      '10-18-1975',
      NULL,
      NULL,
      NULL,
      45.804896,
      '10-29-1977',
      NULL,
      ' 9- 6-1998',
      18.242996,
      17,
      NULL,
      NULL,
      15,
      ' 2-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      47.113615,
      62,
      ' 5-22-1999',
      1,
      6.363904,
      NULL,
      NULL,
      NULL,
      NULL,
      36.845733,
      ' 0- 5-1978',
      23,
      0.341798,
      101.269892,
      ' 4-29-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


