set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6711970';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3214',
      '23434044',
      NULL,
      '33230412',
      NULL,
      '04442013',
      NULL,
      '33444410',
      '34304401',
      '02420432',
      NULL,
      '31014043',
      '42434320',
      '41021004',
      '42230003',
      '30124220',
      NULL,
      '33211203',
      '03040434',
      NULL,
      NULL,
      '02103203',
      '12122302',
      '02130444',
      '10120013',
      NULL,
      '34432204',
      '30131434',
      '41301003',
      NULL,
      '03022122',
      '03422334',
      '30213243',
      '12312034',
      NULL,
      '20000140',
      '22314204',
      '14202024',
      '11010341',
      '34104043',
      '32014200',
      NULL,
      '43442221',
      '32424213',
      '44343132',
      '',
      '',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      '202033',
      3.883398,
      NULL,
      ' 5- 6-1977',
      37.093324,
      NULL,
      38.758448,
      12.956905,
      26.181574,
      29.255798,
      8.828830,
      34.912931,
      29.545894,
      21.703689,
      40.320677,
      NULL,
      NULL,
      5,
      23,
      17,
      3,
      19,
      NULL,
      22,
      7.436160,
      NULL,
      45,
      13.822134,
      NULL,
      92.542864,
      163,
      NULL,
      178.350935,
      NULL,
      254.862883,
      ' 6-28-1978',
      66.508067,
      73.451527,
      NULL,
      16,
      66,
      172,
      ' 3- 6-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-19-1974',
      23,
      NULL,
      135,
      64.904203,
      77,
      NULL,
      23,
      43,
      NULL,
      33.687129,
      47,
      11,
      '10-21-1993',
      20,
      28.797392,
      24.525572,
      62,
      38,
      30,
      NULL,
      ' 8-27-1979',
      NULL,
      17,
      ' 7-16-1975',
      NULL,
      1,
      16,
      2,
      9,
      3.595695,
      NULL,
      17.476057,
      NULL,
      89,
      0,
      9.902441,
      27.389035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-22-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11.669272,
      39,
      NULL,
      1.331056,
      99.152307,
      ' 5- 4-1974',
      14,
      3,
      4,
      33.597519,
      ' 6-19-2001',
      49,
      0.479158,
      101,
      ' 9-25-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.324690,
      0,
      53.891210,
      0,
      NULL,
      38.715991,
      NULL,
      NULL,
      137.662934,
      1.923151,
      1,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396419,
      0,
      0.581741,
      0.381895,
      1.193735,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.265275,
      1,
      NULL,
      36,
      14,
      31,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 7-1995',
      ' 7-26-1994',
      NULL,
      NULL,
      ' 4-13-1978',
      NULL,
      NULL);
commit;
end;
/


