set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9304467';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2431',
      NULL,
      '42122001',
      '11212424',
      '31101234',
      '33322134',
      '23240134',
      '22341414',
      '44302344',
      '33144000',
      '20013042',
      NULL,
      '33211442',
      '12313433',
      NULL,
      '30221240',
      '34400242',
      '03122424',
      '24121214',
      NULL,
      '03031211',
      NULL,
      '43202311',
      '14324342',
      NULL,
      NULL,
      '31042113',
      '22141404',
      NULL,
      '34242023',
      '41334142',
      '34030330',
      '20012440',
      '13432123',
      NULL,
      '34230410',
      '14143044',
      NULL,
      '14220004',
      '02212134',
      NULL,
      NULL,
      NULL,
      '40111143',
      '40000200',
      '241',
      '24',
      NULL,
      NULL,
      NULL,
      1.093072,
      NULL,
      1,
      NULL,
      '332114',
      3,
      ' 3-23-2003',
      NULL,
      71,
      NULL,
      15.964012,
      14,
      10,
      NULL,
      103.074195,
      NULL,
      NULL,
      28.911600,
      45,
      12.380984,
      34.512404,
      5.135904,
      7,
      8,
      11.128337,
      NULL,
      2.577922,
      17,
      48.567350,
      NULL,
      NULL,
      5.045955,
      1.269732,
      NULL,
      NULL,
      16.495281,
      85.063577,
      NULL,
      202,
      ' 2-24-1987',
      61.679377,
      22,
      NULL,
      NULL,
      86,
      141.550756,
      ' 9-18-1986',
      0.332967,
      NULL,
      0,
      1,
      NULL,
      2.578083,
      0,
      3,
      1,
      0.508590,
      3.989561,
      NULL,
      0,
      0,
      0,
      1.175832,
      NULL,
      1,
      1.837297,
      2.772815,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 3-1996',
      56.317308,
      5,
      6.797976,
      0.744124,
      6.003985,
      1.328344,
      ' 4- 4-1986',
      1.490302,
      0.789146,
      202,
      1,
      2,
      98,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-10-1990',
      52,
      45,
      2.908332,
      NULL,
      79.870680,
      81,
      NULL,
      19,
      58,
      9.326974,
      37.590519,
      20,
      ' 4-28-1988',
      NULL,
      NULL,
      2.696657,
      35,
      47,
      35.233318,
      NULL,
      ' 3-23-1976',
      12.127551,
      0.273654,
      ' 0-26-2002',
      NULL,
      6.943837,
      7.942969,
      10,
      26.845694,
      10,
      1.280925,
      10,
      1,
      100,
      1,
      7,
      NULL,
      20,
      0.809179,
      2.031392,
      4.255707,
      1.239861,
      ' 1- 4-1974',
      5,
      NULL,
      7,
      ' 0-14-1989',
      159,
      5.735891,
      NULL,
      21,
      0.890156,
      '10-29-1999',
      33,
      ' 6-26-1985',
      36.907786,
      ' 7-22-1977',
      12.877550,
      8.962912,
      ' 2-16-1977',
      10.536378,
      77.066304,
      '11-21-1978',
      1,
      20.932082,
      ' 0-25-1988',
      NULL,
      NULL,
      NULL,
      2,
      1,
      26.264571,
      NULL,
      5,
      7.502901,
      0,
      ' 2- 4-1992',
      NULL,
      141.618536,
      ' 2- 8-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


