set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9004366';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2414',
      '42440040',
      '22203301',
      '44343133',
      '44111242',
      '43124101',
      '43324044',
      '01124303',
      '30400013',
      '41414434',
      '03013122',
      '13433224',
      '44434043',
      NULL,
      '24132202',
      '02032420',
      NULL,
      NULL,
      '30143142',
      NULL,
      '21021340',
      '10112232',
      '01441003',
      '03130232',
      '23400422',
      NULL,
      '02330144',
      '02032300',
      NULL,
      '31140331',
      '03113313',
      '00121101',
      '44034313',
      '44422324',
      '34344122',
      '34202203',
      '02344113',
      '12022310',
      '11300331',
      '14043133',
      '40022042',
      '44122424',
      '11013142',
      '43300413',
      '12424440',
      '',
      NULL,
      NULL,
      NULL,
      '4224232',
      NULL,
      1.262544,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-23-1992',
      ' 6- 4-1994',
      16.438992,
      NULL,
      NULL,
      NULL,
      15,
      1.204323,
      NULL,
      5,
      NULL,
      4.111053,
      10.412680,
      3.618582,
      23,
      12,
      11,
      0.395395,
      3.042457,
      NULL,
      5,
      11.509650,
      7.083287,
      2,
      41,
      11,
      NULL,
      60.190022,
      93,
      NULL,
      52,
      40.556401,
      19,
      ' 4- 2-1976',
      0,
      3,
      0.184446,
      0,
      17,
      99,
      ' 1-14-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-23-1981',
      69,
      1,
      38,
      21,
      25,
      50.938284,
      49.724582,
      NULL,
      22,
      0,
      39.854920,
      47.513154,
      NULL,
      13.094555,
      NULL,
      9,
      15,
      23.726826,
      3.838794,
      5.841256,
      ' 2-16-2002',
      2,
      NULL,
      NULL,
      3.800644,
      1,
      7,
      0.333265,
      0.462457,
      3.796163,
      NULL,
      11,
      NULL,
      19,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0- 9-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      12.241852,
      ' 3-13-1988',
      9,
      46,
      5.303614,
      47.758915,
      '10-27-1976',
      NULL,
      0.131540,
      155,
      ' 7-18-2002',
      NULL,
      NULL,
      NULL,
      7.481697,
      NULL,
      NULL,
      NULL,
      37.962069,
      126.748550,
      74.163119,
      54.990527,
      16,
      35,
      4,
      32.075147,
      3,
      1,
      76,
      NULL,
      NULL,
      NULL,
      6,
      0.002162,
      187.152990,
      NULL,
      11.524664,
      270.348206,
      36.702033,
      7,
      67,
      0.098066,
      3,
      0,
      0.191704,
      1,
      3.574758,
      1,
      0.045895,
      9,
      7,
      0,
      1,
      37,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.887060,
      0.178165,
      11,
      6.791384,
      1.663409,
      8.178249,
      26.436502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.109055,
      NULL,
      3,
      0,
      2,
      62.069770,
      ' 6-15-1974',
      '10- 5-1996',
      ' 0-11-1981',
      NULL,
      ' 2- 0-1977',
      NULL,
      ' 9-26-1986',
      NULL);
commit;
end;
/


