set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9686190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3404',
      NULL,
      '12424403',
      NULL,
      '01422234',
      NULL,
      '43333344',
      NULL,
      '21424012',
      NULL,
      '01333034',
      '23024043',
      NULL,
      NULL,
      NULL,
      '31202144',
      '23104011',
      '22433443',
      '22221330',
      NULL,
      '41244114',
      '03431114',
      '02414141',
      '00024003',
      NULL,
      '32241401',
      '13133103',
      '30000410',
      '41230124',
      '42303341',
      '10133134',
      '01320301',
      '34031243',
      '22104330',
      NULL,
      '40332140',
      '11141434',
      '23400331',
      NULL,
      '31340240',
      '42234331',
      '42003221',
      '42101224',
      '12203003',
      '30400001',
      NULL,
      '12',
      20,
      5.630883,
      '4424403',
      NULL,
      1.203245,
      3,
      NULL,
      '003012',
      NULL,
      ' 1-21-1985',
      ' 7- 4-2001',
      NULL,
      15.971946,
      4,
      6,
      16.824811,
      33.695237,
      90.319308,
      10.349705,
      19,
      0,
      8.830847,
      11.508769,
      36,
      4,
      NULL,
      10,
      2,
      9.232509,
      63.748693,
      NULL,
      68,
      NULL,
      48.142231,
      16,
      0,
      20.307120,
      NULL,
      30,
      82.910816,
      86,
      104.031555,
      '10- 8-1988',
      32,
      NULL,
      34.179321,
      19.293815,
      124,
      26,
      ' 7-21-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77.468461,
      13.211274,
      8.988012,
      4,
      0.378552,
      8.681948,
      NULL,
      1.138222,
      NULL,
      106,
      1.524307,
      1,
      106,
      1,
      3,
      77.040138,
      NULL,
      NULL,
      NULL,
      '10-24-1980',
      16,
      NULL,
      NULL,
      70.228031,
      71.883679,
      NULL,
      77,
      18.542356,
      NULL,
      53,
      51.167087,
      NULL,
      ' 2- 1-1983',
      13,
      9.030825,
      NULL,
      13,
      20.796372,
      16,
      NULL,
      ' 8-17-1998',
      10.015408,
      3.463270,
      ' 4-14-1987',
      7,
      NULL,
      20.343806,
      1.112653,
      16,
      NULL,
      1,
      NULL,
      1.630780,
      38,
      NULL,
      0.533512,
      8,
      16.574431,
      5,
      NULL,
      3,
      1,
      '11-26-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      151.186746,
      2.639543,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-13-1979',
      16,
      NULL,
      10.642371,
      5,
      ' 0-14-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      8,
      ' 4-16-1995',
      7,
      2.332054,
      27,
      NULL,
      0.214903,
      12.343615,
      ' 2-13-1985',
      NULL,
      14.520235,
      NULL,
      9.844223,
      NULL,
      46,
      0,
      NULL,
      ' 8-13-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


