set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0101493';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '1',
      NULL,
      '0',
      '3',
      '2',
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      '2',
      '3',
      '3',
      '4',
      '2',
      '0',
      '0',
      '0',
      '2',
      '2',
      '3',
      '',
      '3',
      '',
      '1',
      '3',
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '0',
      '1',
      '1',
      '1',
      '0',
      '3',
      NULL,
      '2',
      '3',
      '4',
      '3',
      '020',
      '20120111',
      38,
      NULL,
      '4010312',
      2,
      1.903175,
      3,
      0,
      '113434',
      NULL,
      ' 9- 7-1980',
      NULL,
      58.113650,
      60,
      45.983320,
      22,
      22.278296,
      25,
      69.776684,
      21,
      18.369778,
      13.697702,
      10.759258,
      24,
      4.127396,
      12.093120,
      3,
      NULL,
      0,
      19,
      NULL,
      15,
      32.520811,
      NULL,
      76.640931,
      NULL,
      0,
      29.405723,
      178.105333,
      77,
      NULL,
      70,
      31.023808,
      ' 5-24-1982',
      2,
      52.356454,
      32,
      21.142299,
      NULL,
      85,
      ' 2- 0-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      56.288448,
      NULL,
      32,
      25.654603,
      23.053224,
      3,
      ' 6-20-2001',
      NULL,
      1,
      114.498415,
      1,
      1.100643,
      0.157220,
      NULL,
      NULL,
      0.237207,
      NULL,
      NULL,
      NULL,
      '10-22-1976',
      54,
      79,
      105.109646,
      63,
      115.890932,
      NULL,
      49.146698,
      56.860563,
      53,
      42.795683,
      26,
      78,
      ' 5- 6-1974',
      NULL,
      11.403217,
      NULL,
      49,
      21.916820,
      19.830287,
      NULL,
      ' 2- 2-1998',
      NULL,
      6.653876,
      ' 4-14-1991',
      9.878339,
      8,
      2,
      12.006966,
      24.204077,
      1.911455,
      0.968111,
      1,
      NULL,
      50.614161,
      NULL,
      8.001640,
      NULL,
      NULL,
      1.801808,
      3.964546,
      NULL,
      0,
      ' 7-23-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      7.179214,
      NULL,
      NULL,
      NULL,
      NULL,
      30,
      NULL,
      41.243164,
      ' 6- 3-2001',
      8,
      14.698935,
      ' 1-19-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      14.034665,
      '11-13-1990',
      41.482036,
      33,
      22,
      '10-20-1974',
      3,
      25,
      ' 3- 3-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


