set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9433925';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14144113',
      '11110112',
      '44411110',
      '30332324',
      NULL,
      '30303312',
      '40140324',
      NULL,
      '22013032',
      '02233220',
      '33432241',
      '03440402',
      '14442320',
      '00344320',
      NULL,
      NULL,
      '02113110',
      NULL,
      '11111404',
      '34042321',
      '21402003',
      '22431411',
      '00424230',
      '33331103',
      '13404021',
      '04234221',
      NULL,
      '32111344',
      '34113341',
      '13240414',
      '24002223',
      '22412002',
      '00310040',
      '11404102',
      '00434133',
      NULL,
      '21032330',
      '33301112',
      '00422310',
      '13442222',
      '23420301',
      '20132042',
      '04034413',
      '02132221',
      NULL,
      '34',
      NULL,
      NULL,
      NULL,
      1.071129,
      0,
      0,
      NULL,
      '312414',
      2,
      ' 9- 9-1993',
      ' 1-15-1993',
      126,
      NULL,
      3.633607,
      0.882045,
      27,
      NULL,
      28,
      15,
      6,
      NULL,
      9.938779,
      NULL,
      17,
      7,
      NULL,
      18.819225,
      18.158161,
      7,
      NULL,
      17,
      NULL,
      0.903947,
      53.862477,
      8,
      1.177361,
      21,
      15,
      50,
      NULL,
      63.542602,
      30.768307,
      ' 8- 4-1993',
      46.010503,
      17.418121,
      11.264829,
      8.791079,
      6.862103,
      57,
      ' 2-10-1995',
      7.751549,
      1.167009,
      3.867229,
      0.860813,
      4.231733,
      3,
      6.211995,
      0,
      1,
      1,
      4.032857,
      0,
      1,
      0,
      NULL,
      1.734290,
      1,
      0,
      0.040475,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.198304,
      13.627138,
      NULL,
      13,
      NULL,
      0,
      NULL,
      0,
      0.029370,
      53.743588,
      0.741093,
      4,
      20.492989,
      NULL,
      3,
      74.856549,
      NULL,
      NULL,
      NULL,
      ' 1-15-2003',
      10.484122,
      NULL,
      93,
      30.349370,
      61,
      NULL,
      NULL,
      66.469971,
      76.059608,
      80,
      NULL,
      73,
      ' 1-20-1980',
      13.858933,
      11,
      2,
      42,
      10,
      14,
      5,
      ' 4- 6-1998',
      NULL,
      0.434051,
      '10-11-1998',
      1.872139,
      19,
      14,
      4,
      17.553240,
      14,
      1.328603,
      16,
      NULL,
      60.133187,
      NULL,
      2.918323,
      13.847565,
      NULL,
      0.220797,
      1.279348,
      1.772316,
      0.943010,
      ' 8-25-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      2.615422,
      ' 6- 3-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 3-1995',
      5.257556,
      ' 7- 8-1991',
      8,
      NULL,
      NULL,
      103.450238,
      NULL,
      ' 7-18-2000',
      5.720044,
      1,
      ' 8-25-1991',
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      ' 1- 0-2003',
      72,
      23.699982,
      NULL,
      ' 6-11-2002',
      NULL,
      34,
      ' 8-22-1993',
      11,
      NULL,
      13,
      94,
      '11- 6-1998',
      NULL,
      NULL,
      129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


