set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9403031';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2102',
      '31300102',
      '24241441',
      '43310024',
      '30122101',
      '42403222',
      '20143402',
      '22302412',
      '34312324',
      '20442322',
      NULL,
      '03230013',
      '40234410',
      NULL,
      '34010420',
      NULL,
      '14133201',
      '00310411',
      NULL,
      '30322224',
      NULL,
      '24020343',
      NULL,
      '41241123',
      '03411142',
      '12200111',
      '43314403',
      '03131330',
      '22131244',
      NULL,
      '03122010',
      NULL,
      '23212204',
      '30342123',
      NULL,
      '44033221',
      '43142414',
      NULL,
      '31131341',
      '03110001',
      '33041020',
      '10030201',
      NULL,
      '23314144',
      NULL,
      '430',
      '02',
      4,
      2.770392,
      '4214423',
      0,
      1,
      3,
      NULL,
      '103002',
      4.378996,
      '10-26-1978',
      NULL,
      6,
      62.029612,
      13,
      6,
      NULL,
      4.470535,
      70,
      1.638778,
      NULL,
      NULL,
      35.472259,
      3.660264,
      12.248272,
      8,
      26,
      0.404847,
      7.023147,
      NULL,
      32.539640,
      15,
      16,
      7.348382,
      37.553433,
      NULL,
      1.668126,
      99.319372,
      65.732328,
      24.058810,
      176.613357,
      91.710816,
      189.731042,
      NULL,
      NULL,
      NULL,
      7.992122,
      7.450995,
      114.036622,
      219,
      ' 2-22-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      1,
      1,
      NULL,
      2.381455,
      0,
      ' 0- 5-1981',
      0,
      0,
      23.141677,
      1.692549,
      0.696309,
      NULL,
      0,
      1.439381,
      48,
      NULL,
      NULL,
      NULL,
      '10- 0-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      20,
      50,
      26,
      21,
      11.690299,
      ' 4- 5-1990',
      39.641198,
      24,
      NULL,
      NULL,
      NULL,
      15.867878,
      12.766791,
      0,
      0.446278,
      0,
      8.339318,
      NULL,
      39,
      0.522883,
      7,
      24,
      16.566095,
      0,
      0,
      NULL,
      NULL,
      ' 5-18-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      170.426979,
      2,
      ' 8-13-1980',
      NULL,
      NULL,
      NULL,
      6.344858,
      ' 8- 4-1987',
      NULL,
      ' 7- 0-1992',
      7,
      2,
      ' 2-29-1982',
      133,
      58,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      25,
      ' 5- 0-1978',
      48,
      NULL,
      NULL,
      ' 7-23-1983',
      1,
      5.433698,
      ' 8- 9-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


