set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2041',
      '21121420',
      '23032103',
      '10212044',
      '12333212',
      '41313303',
      '43133242',
      '34210210',
      '24410221',
      '41034313',
      '12133441',
      '04400430',
      '12423201',
      '04123431',
      '41202241',
      '04110024',
      '02421133',
      NULL,
      '00342440',
      '01110233',
      '14112313',
      NULL,
      NULL,
      '20304303',
      '23403402',
      '34003032',
      NULL,
      '13403440',
      '10031132',
      '14110024',
      NULL,
      NULL,
      '10331132',
      '40044423',
      '44233243',
      '44313004',
      '30333421',
      '42113412',
      '31334323',
      '02143402',
      '24433024',
      '32001312',
      '22211041',
      NULL,
      '33231341',
      '424',
      '02',
      NULL,
      NULL,
      '2044310',
      0.426198,
      1.380522,
      0,
      NULL,
      '123300',
      NULL,
      ' 9- 7-2003',
      '11- 7-2001',
      NULL,
      NULL,
      9,
      NULL,
      21.520113,
      13,
      91.448791,
      4.910983,
      NULL,
      23.752905,
      40,
      21.400074,
      42,
      11.927182,
      NULL,
      NULL,
      18.321224,
      1,
      NULL,
      18.743805,
      NULL,
      21.976316,
      99,
      NULL,
      0,
      106,
      167,
      115,
      18,
      129,
      NULL,
      NULL,
      3,
      15,
      36,
      10.427024,
      10.244413,
      20.160223,
      ' 1-28-2001',
      4,
      1.709204,
      0,
      NULL,
      0.541555,
      3.955819,
      1,
      1.174879,
      0,
      NULL,
      1.040212,
      NULL,
      1.449360,
      1,
      3,
      1.161374,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-29-1986',
      81,
      NULL,
      5,
      0.133937,
      12,
      NULL,
      NULL,
      0,
      1,
      129,
      NULL,
      3.796043,
      50.438510,
      NULL,
      1,
      9.922751,
      NULL,
      NULL,
      NULL,
      NULL,
      29.806935,
      3.708157,
      32.339139,
      50.976496,
      42,
      62,
      37.280553,
      NULL,
      9,
      76.698527,
      67.561855,
      33,
      ' 5- 4-1975',
      NULL,
      31,
      18,
      33,
      NULL,
      128.109817,
      NULL,
      NULL,
      3,
      17,
      ' 1-22-1995',
      NULL,
      23.103875,
      14.130130,
      NULL,
      NULL,
      12.543497,
      0,
      12,
      0.211687,
      NULL,
      NULL,
      1,
      5,
      9.866819,
      0,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      1,
      ' 7-13-1998',
      75.373681,
      99,
      '10-27-1978',
      NULL,
      NULL,
      NULL,
      14.058183,
      ' 4-28-1998',
      8,
      NULL,
      8.266058,
      NULL,
      ' 9-11-1999',
      NULL,
      NULL,
      NULL,
      7.507305,
      1.525959,
      '10-11-1987',
      NULL,
      NULL,
      NULL,
      0,
      0,
      5.657286,
      ' 8-23-1990',
      29,
      26.046348,
      13.320781,
      NULL,
      NULL,
      66,
      ' 3-20-1989',
      18.724561,
      NULL,
      4,
      31.184565,
      ' 0- 4-1985',
      NULL,
      NULL,
      106.502111,
      ' 7-18-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17);
commit;
end;
/


