set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '1',
      '0',
      '3',
      '3',
      '1',
      '2',
      '3',
      '0',
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '4',
      '0',
      '3',
      '3',
      '4',
      '1',
      '1',
      '1',
      '3',
      '',
      '3',
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      NULL,
      '',
      '',
      '0',
      '4',
      '1',
      NULL,
      NULL,
      '1',
      '2',
      '2',
      '4',
      '3',
      '4',
      '412',
      '32203313',
      9.992391,
      47.744067,
      '1122433',
      2,
      60.197376,
      0,
      NULL,
      '140414',
      2.327754,
      ' 0- 5-1982',
      NULL,
      NULL,
      NULL,
      34.405716,
      14,
      NULL,
      21,
      17,
      13.116397,
      NULL,
      2,
      NULL,
      2.134437,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      14.811931,
      NULL,
      21.635223,
      33.387474,
      9,
      14,
      15.980670,
      0.973269,
      69.414888,
      110,
      35.661338,
      131,
      125,
      NULL,
      ' 6- 1-1995',
      53.774474,
      16,
      15,
      NULL,
      38,
      136,
      '11-22-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.506301,
      49,
      NULL,
      16,
      5,
      NULL,
      NULL,
      0.154519,
      NULL,
      1.420393,
      NULL,
      155.248534,
      1.816704,
      1.985662,
      47,
      NULL,
      NULL,
      NULL,
      ' 0-19-1990',
      72.703100,
      31,
      57,
      69.318503,
      57.490967,
      NULL,
      30,
      96.457334,
      8.680250,
      17.528272,
      NULL,
      NULL,
      NULL,
      34.762014,
      7,
      14,
      76,
      57,
      2.939231,
      4,
      ' 4-27-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      163,
      64.056605,
      ' 1-28-1990',
      NULL,
      NULL,
      NULL,
      12.713102,
      ' 3- 1-1992',
      25.704521,
      NULL,
      0,
      3,
      ' 4-29-1976',
      NULL,
      125.419104,
      ' 1- 0-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      11.241072,
      NULL,
      1.827653,
      NULL,
      9.789521,
      NULL,
      1.637054,
      NULL,
      ' 9-14-2000',
      NULL,
      30,
      13.965282,
      NULL,
      NULL,
      NULL,
      0,
      113,
      ' 2- 7-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


