set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9509958';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '2',
      '0',
      '2',
      '0',
      '4',
      '1',
      '2',
      '1',
      '3',
      '0',
      '1',
      '2',
      '4',
      '2',
      '1',
      '3',
      '3',
      '4',
      '4',
      '2',
      '0',
      NULL,
      '',
      '2',
      '',
      '1',
      '3',
      '2',
      '4',
      NULL,
      '',
      '',
      '4',
      NULL,
      '1',
      NULL,
      '2',
      '0',
      '4',
      '2',
      '3',
      '0',
      '3',
      NULL,
      '11242143',
      68,
      NULL,
      '0244223',
      NULL,
      1,
      0,
      1,
      '202133',
      5,
      NULL,
      ' 4-13-1986',
      205.552762,
      16.243116,
      28,
      13,
      12,
      10.234149,
      21.342870,
      10.146775,
      NULL,
      8,
      7.349120,
      12,
      NULL,
      21.132505,
      NULL,
      10.937601,
      26.728842,
      0,
      NULL,
      NULL,
      10.817433,
      1,
      143.874358,
      14,
      0,
      82.030144,
      NULL,
      NULL,
      120.637926,
      56,
      116.232638,
      ' 4-26-1994',
      35.493216,
      43,
      0.591739,
      10,
      105.398035,
      201.625459,
      ' 3-29-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      29.139154,
      8,
      7,
      16.174765,
      2.324987,
      ' 6- 4-1989',
      0.960519,
      0.214821,
      82.958965,
      1,
      3,
      4,
      0.921073,
      0,
      81,
      NULL,
      NULL,
      NULL,
      ' 6-29-1992',
      9.437590,
      12.258837,
      53.210237,
      39,
      NULL,
      83.389516,
      69,
      66,
      NULL,
      31.300277,
      1.789096,
      NULL,
      NULL,
      NULL,
      30,
      NULL,
      65,
      71.995476,
      92,
      NULL,
      ' 9-19-1989',
      25.182612,
      8.766071,
      '10-17-2000',
      1.704822,
      7.810964,
      8.830954,
      8,
      NULL,
      12,
      0,
      6.080083,
      NULL,
      84.733044,
      1.267988,
      1.525071,
      15.592554,
      23,
      0,
      0.872375,
      0.068573,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      139,
      25.172516,
      ' 4-22-2002',
      NULL,
      NULL,
      NULL,
      22,
      ' 6- 2-1977',
      14,
      '11-19-2002',
      3,
      7.934424,
      ' 1-16-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-19-1993',
      57,
      18,
      16.004093,
      ' 7- 8-1981',
      NULL,
      42.784949,
      ' 5- 5-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


