set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4202',
      '04021134',
      NULL,
      '31203443',
      '44123132',
      '02031313',
      '14011411',
      '00432313',
      '41040144',
      NULL,
      '24242121',
      '30241233',
      NULL,
      '34044212',
      '44031204',
      '24422410',
      '34424143',
      NULL,
      '12333240',
      '02130343',
      '33422302',
      '34210311',
      '41004442',
      '41140324',
      '03443334',
      '14224400',
      '00114223',
      '03234213',
      '34400234',
      '42122333',
      '03323141',
      '01241444',
      '00143232',
      '12104000',
      NULL,
      '01114101',
      '43132441',
      '12021224',
      '30212212',
      '22124402',
      '23334422',
      '01401220',
      '01310221',
      '23404221',
      '04424423',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      '404014',
      2.140454,
      ' 6-17-2003',
      ' 6- 1-1983',
      7.492914,
      NULL,
      18,
      5,
      12,
      7.344610,
      119,
      24,
      11,
      20.949720,
      0.886172,
      15,
      9,
      29.584104,
      11,
      NULL,
      12,
      5,
      13,
      23,
      30,
      8,
      8.318570,
      NULL,
      NULL,
      106.453714,
      NULL,
      64,
      124,
      27,
      227.360163,
      ' 0- 2-1979',
      NULL,
      NULL,
      17.957317,
      NULL,
      65,
      173,
      ' 4-17-1996',
      2.313573,
      0.950750,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.888466,
      3,
      1.255502,
      1.507770,
      3.780982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-23-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-16-1977',
      72.203771,
      13,
      81.682264,
      24,
      NULL,
      85.043925,
      10.240243,
      NULL,
      96,
      20.919695,
      86.916619,
      117.788405,
      ' 7-14-1995',
      0.526923,
      20.938220,
      NULL,
      5,
      NULL,
      NULL,
      9,
      ' 9-10-2002',
      15.720264,
      1.697439,
      ' 1-15-1995',
      6,
      5.728481,
      13,
      17,
      9,
      2,
      NULL,
      16,
      NULL,
      51,
      1,
      1,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.280729,
      NULL,
      64,
      ' 3- 9-1986',
      NULL,
      41.330408,
      NULL,
      3,
      1,
      14.140387,
      7,
      ' 9- 4-1978',
      46.553138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      2,
      27.760633,
      NULL,
      NULL,
      NULL,
      9,
      16,
      3,
      0,
      62.339049,
      0.855540,
      0.403701,
      49,
      0,
      0,
      29.490886,
      1,
      1,
      110,
      3,
      2.581735,
      41.177153,
      84.514239,
      31.340814,
      56.048958,
      1.261525,
      55.342984,
      0.512474,
      0,
      0,
      1,
      0,
      1,
      47,
      100,
      50.725759,
      22,
      NULL,
      40.910039,
      1.477391,
      0.844408,
      47.548482,
      0.317887,
      0,
      NULL,
      NULL,
      NULL,
      16,
      3,
      20,
      0,
      6,
      83.132474,
      9,
      2,
      14.260122,
      82.752198,
      81,
      23,
      23,
      7,
      0.281350,
      1.820725,
      NULL,
      1.485651,
      2,
      NULL,
      1,
      NULL,
      ' 4-14-1978',
      ' 2-27-1982',
      ' 7-14-1987',
      ' 9-28-1987',
      ' 6-17-1997',
      ' 0-29-2001',
      ' 8-23-2003',
      NULL);
commit;
end;
/


