set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2124',
      '41403342',
      '03240143',
      '23313103',
      NULL,
      '13244422',
      '20331300',
      NULL,
      '30011400',
      '24004241',
      NULL,
      '03312133',
      '34313122',
      NULL,
      '13440224',
      '01313410',
      '20240311',
      '23124113',
      '10034231',
      '04223403',
      '11320144',
      '30444012',
      '31144042',
      NULL,
      NULL,
      NULL,
      '22034100',
      '20003322',
      '02332024',
      '24443012',
      '32003033',
      '21332041',
      '04020314',
      '41213322',
      NULL,
      '44134300',
      '10320301',
      '23214421',
      '03413133',
      NULL,
      '13010311',
      NULL,
      '34223442',
      NULL,
      NULL,
      '111',
      '04',
      NULL,
      NULL,
      '3224224',
      0,
      33.464710,
      3,
      NULL,
      '001432',
      2.008767,
      ' 7-24-1980',
      ' 3- 8-1982',
      3,
      NULL,
      33,
      NULL,
      29.891102,
      5.846191,
      NULL,
      15,
      9.953622,
      7,
      1.283273,
      12,
      4,
      NULL,
      3.922178,
      23.023287,
      12,
      NULL,
      NULL,
      17.171252,
      NULL,
      12.059534,
      84.542621,
      NULL,
      1,
      NULL,
      226,
      48.045388,
      NULL,
      101.095149,
      190,
      ' 9- 6-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.410316,
      1.025941,
      0.972536,
      0,
      NULL,
      1.429511,
      7,
      5,
      1.611046,
      1.665718,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-15-2002',
      87,
      NULL,
      3,
      NULL,
      NULL,
      3,
      ' 5- 4-1985',
      0,
      1.914450,
      86,
      0,
      1.969391,
      2,
      1,
      NULL,
      53.050861,
      1,
      1.475811,
      111,
      ' 8-17-1993',
      NULL,
      12,
      NULL,
      NULL,
      4,
      NULL,
      145.114058,
      46,
      17.021023,
      16.956618,
      94,
      70,
      ' 0-12-1975',
      5,
      3.742795,
      17,
      67.886052,
      49.018756,
      NULL,
      12,
      '11-14-1986',
      15,
      26,
      ' 4- 9-1990',
      5,
      17.067367,
      NULL,
      0.122757,
      17.569552,
      3.813452,
      NULL,
      8.578143,
      1,
      45.692308,
      NULL,
      1.195875,
      NULL,
      9,
      1.190270,
      0.878900,
      1,
      0,
      ' 1-12-1978',
      NULL,
      5,
      1.322569,
      ' 9-16-1986',
      NULL,
      1.873035,
      ' 3- 1-2000',
      NULL,
      NULL,
      NULL,
      45.982559,
      ' 4-12-1979',
      43,
      ' 5-12-2003',
      12.846180,
      10,
      '11-18-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      7.190471,
      '11-24-1987',
      1,
      1,
      4.316121,
      ' 0- 4-1999',
      37,
      49,
      37,
      '11-20-1992',
      1,
      91,
      NULL,
      13,
      39,
      10,
      4,
      ' 5-23-1974',
      7.573425,
      1.881940,
      NULL,
      ' 4-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.056391);
commit;
end;
/


