set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1433',
      NULL,
      '03034041',
      NULL,
      '01013112',
      '43011242',
      '30421101',
      NULL,
      '12412012',
      '20002114',
      NULL,
      NULL,
      '41034132',
      '42213421',
      '14113140',
      '03223042',
      NULL,
      '10221013',
      '22110023',
      '31243300',
      '20221024',
      NULL,
      '12241211',
      '03003043',
      '31403341',
      NULL,
      NULL,
      '14404100',
      '42021241',
      NULL,
      '23344442',
      NULL,
      '14214440',
      '02032310',
      NULL,
      '32110022',
      '11003210',
      '04440222',
      '24204044',
      '21010343',
      '44442342',
      '24331121',
      NULL,
      '13211432',
      '03440003',
      NULL,
      NULL,
      NULL,
      NULL,
      '4012241',
      3.795350,
      107.617559,
      1,
      NULL,
      '404330',
      NULL,
      NULL,
      ' 9- 2-1976',
      84.909046,
      NULL,
      NULL,
      19.508441,
      20,
      15,
      NULL,
      4.668600,
      4.293156,
      4.077590,
      41.880029,
      19.469920,
      35,
      11.438729,
      20.902912,
      10,
      22.723432,
      2,
      52,
      12.407869,
      74.139812,
      NULL,
      66,
      11.533906,
      1.209475,
      108.814727,
      73,
      120.129970,
      NULL,
      147,
      34.131533,
      ' 9-13-1992',
      60.576269,
      32.060671,
      34.030199,
      11,
      57,
      162.502852,
      NULL,
      0.359363,
      0,
      5,
      9.026613,
      2,
      0.617882,
      0.046670,
      1.786534,
      0.157970,
      1.108186,
      2,
      1.676081,
      1.920429,
      2.777024,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-20-1985',
      71,
      NULL,
      1.654972,
      18,
      1.179431,
      4.713153,
      '10-27-1997',
      1,
      0,
      154,
      1,
      NULL,
      71.137397,
      1.608449,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 8-1994',
      18.683865,
      NULL,
      16.791559,
      NULL,
      59,
      41,
      62,
      30,
      NULL,
      5,
      43.988149,
      37,
      ' 8-29-1977',
      15,
      20,
      22,
      69,
      NULL,
      13,
      8.581663,
      '10- 9-1981',
      17.177877,
      16.998613,
      NULL,
      6,
      14.125672,
      17,
      9.478305,
      12,
      7.132066,
      1,
      3,
      0,
      17,
      0,
      0.004965,
      1,
      3.101318,
      3.507243,
      NULL,
      NULL,
      NULL,
      ' 1-19-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.785949,
      ' 3-24-1986',
      NULL,
      NULL,
      NULL,
      26.589260,
      NULL,
      NULL,
      '11-29-1978',
      NULL,
      NULL,
      ' 3-25-1984',
      21.499059,
      50.927181,
      ' 0-13-1979',
      8,
      15,
      ' 8-11-1975',
      NULL,
      NULL,
      NULL,
      0,
      1,
      8.133286,
      NULL,
      25.100703,
      32.679088,
      46.431476,
      ' 7- 8-2000',
      1.095316,
      100.075909,
      NULL,
      0,
      8,
      NULL,
      21.696505,
      ' 1- 0-1988',
      48,
      NULL,
      66.154794,
      '11-24-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


