set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '0',
      '0',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      '2',
      '2',
      '4',
      '1',
      '4',
      NULL,
      '0',
      '4',
      '4',
      '1',
      '3',
      '',
      NULL,
      '',
      '2',
      '3',
      '4',
      '2',
      '3',
      '',
      NULL,
      '0',
      '2',
      '0',
      '3',
      NULL,
      NULL,
      '2',
      '4',
      '2',
      NULL,
      '1',
      '042',
      '30',
      23,
      36.126463,
      '0404214',
      0.141964,
      NULL,
      1,
      NULL,
      '333342',
      NULL,
      ' 4- 7-1975',
      ' 5- 9-1987',
      9.382662,
      13,
      17,
      24,
      33.622462,
      17,
      6,
      16,
      12.410305,
      5,
      11.336700,
      8.309293,
      27.820673,
      25,
      37,
      17,
      36,
      7,
      NULL,
      5.098151,
      60.923017,
      2.334766,
      29.492438,
      15.993325,
      1.468689,
      NULL,
      NULL,
      35.322471,
      54,
      184,
      14.322433,
      ' 7-19-1974',
      20,
      54,
      11.031636,
      NULL,
      NULL,
      164.602834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.625516,
      20,
      11,
      33,
      NULL,
      0.162265,
      ' 5-22-1982',
      1.750507,
      0.058322,
      107,
      1.251442,
      4,
      90,
      0,
      5,
      29,
      NULL,
      NULL,
      NULL,
      ' 8- 3-1993',
      37,
      20,
      78,
      18.740389,
      12,
      75,
      15.274275,
      110,
      71.696312,
      89,
      10,
      94.495259,
      NULL,
      16.277838,
      NULL,
      3,
      22.586573,
      50.471776,
      NULL,
      8.558540,
      ' 2- 7-1983',
      NULL,
      9,
      NULL,
      3,
      7.915417,
      11.971059,
      13.216337,
      1,
      7,
      1,
      9,
      1.130731,
      40.830093,
      8.453967,
      NULL,
      9,
      NULL,
      3,
      1.055116,
      0.206409,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20.283633,
      1.610153,
      ' 8- 4-1982',
      NULL,
      NULL,
      NULL,
      13,
      ' 9-11-1999',
      NULL,
      ' 5-20-1982',
      12.739334,
      NULL,
      ' 7- 3-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      8.839610,
      ' 7-11-1996',
      39.456185,
      38,
      31,
      ' 9-21-2001',
      2,
      NULL,
      ' 4- 5-1984',
      NULL,
      NULL,
      NULL,
      65,
      ' 1-24-1983',
      57,
      NULL,
      118,
      ' 6-17-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


