set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9025199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '4',
      '1',
      NULL,
      '2',
      NULL,
      '4',
      NULL,
      '3',
      '3',
      '4',
      '0',
      '1',
      '2',
      NULL,
      '1',
      '3',
      NULL,
      '3',
      '4',
      NULL,
      '4',
      '0',
      '',
      '3',
      '',
      NULL,
      NULL,
      '2',
      '3',
      '4',
      NULL,
      '',
      '3',
      '1',
      '1',
      '3',
      '1',
      '2',
      '2',
      '2',
      NULL,
      '3',
      NULL,
      '303',
      '10113044',
      77,
      63,
      '2414033',
      NULL,
      NULL,
      1,
      0,
      '204143',
      1.627796,
      NULL,
      '10-16-2000',
      NULL,
      99.101059,
      NULL,
      16.735298,
      NULL,
      17.819326,
      23.547519,
      1.690360,
      NULL,
      1.508605,
      16,
      NULL,
      27,
      NULL,
      20.795908,
      6,
      13.097767,
      NULL,
      NULL,
      14,
      47.975530,
      NULL,
      3.799555,
      13,
      0.672271,
      105.707033,
      1,
      34,
      187.664852,
      125,
      68,
      ' 6- 9-1997',
      45,
      38,
      13.254410,
      19.374715,
      183,
      139.859831,
      ' 5-25-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      5.954215,
      19,
      18.852077,
      18.720059,
      2,
      ' 5-11-1990',
      1.181268,
      1.706967,
      117.890087,
      0.366904,
      1.827723,
      38.193841,
      1,
      1,
      36.215400,
      NULL,
      NULL,
      NULL,
      ' 1-12-2002',
      51.397109,
      67.952013,
      53.700469,
      NULL,
      NULL,
      8,
      56.456229,
      36,
      33,
      63,
      3,
      38.399484,
      ' 3-11-1989',
      17.360922,
      NULL,
      2,
      65,
      35,
      73.304908,
      9,
      ' 9-26-1999',
      7.888731,
      11.363067,
      ' 0- 5-2002',
      9.116097,
      9,
      NULL,
      14,
      13,
      3,
      NULL,
      12,
      1,
      75,
      0.919605,
      0.040497,
      17,
      NULL,
      6.861312,
      NULL,
      NULL,
      1.127263,
      ' 2- 4-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      146.754414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      '11-10-2002',
      10,
      ' 2- 6-1975',
      2,
      12.490573,
      ' 9-16-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      22,
      ' 7-17-1993',
      56,
      39,
      26.768605,
      ' 2-15-1997',
      2.716324,
      183.276699,
      ' 2- 0-1991',
      12,
      99,
      23.509388,
      13,
      ' 1-16-2002',
      NULL,
      0,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


