set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215998';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4222',
      '24031441',
      '23031330',
      '14111121',
      '00200033',
      '40332414',
      NULL,
      NULL,
      '03003040',
      '34043243',
      '24302021',
      NULL,
      '20322340',
      '22244344',
      '14102120',
      '13012240',
      '42244431',
      NULL,
      '21240141',
      '32144300',
      '42432403',
      '30243133',
      '31141210',
      '24420040',
      NULL,
      '03044010',
      '11122034',
      '33304110',
      NULL,
      '24424444',
      '33313304',
      '31422130',
      '23442340',
      '02200330',
      '41222114',
      NULL,
      '14232131',
      '10424032',
      '40021021',
      '03410440',
      '11112112',
      '12240302',
      NULL,
      '42011014',
      '42140030',
      '331',
      '33',
      NULL,
      NULL,
      '3322220',
      NULL,
      1,
      1,
      NULL,
      '014320',
      5.787310,
      NULL,
      ' 1- 1-1986',
      69,
      NULL,
      26.997611,
      27,
      23,
      0.837572,
      21.385890,
      12.987466,
      24,
      21.590129,
      24,
      8.580714,
      NULL,
      17.221428,
      21.914951,
      6,
      NULL,
      0,
      41.763783,
      23,
      NULL,
      18,
      17.184471,
      9,
      0,
      25.143384,
      16.336877,
      NULL,
      NULL,
      157.873335,
      NULL,
      ' 9- 5-1995',
      43,
      43,
      12.414957,
      0,
      47.201224,
      138.645898,
      ' 4- 7-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      110,
      10.161942,
      9.681785,
      1.034678,
      8.040917,
      NULL,
      NULL,
      NULL,
      1.304771,
      126.041324,
      NULL,
      NULL,
      62.516973,
      1,
      0,
      NULL,
      0.439485,
      2.720317,
      49,
      ' 5-10-1980',
      NULL,
      59.797258,
      NULL,
      14.440385,
      5.704462,
      73.175451,
      15,
      0,
      75.800190,
      73.410599,
      27,
      35.720916,
      '11- 6-1996',
      28.427694,
      NULL,
      18.773275,
      NULL,
      9.482671,
      NULL,
      NULL,
      ' 4- 0-1986',
      10.357538,
      11,
      ' 7- 7-1982',
      NULL,
      2,
      24,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.880366,
      90.487983,
      1,
      NULL,
      8.328742,
      3,
      1.548331,
      1.050977,
      NULL,
      0.127042,
      NULL,
      2.585599,
      3.016776,
      0,
      ' 9-16-1992',
      252,
      15,
      NULL,
      42.391956,
      22.804708,
      ' 6- 6-1984',
      21,
      ' 5-10-1989',
      33,
      '11- 2-1982',
      12.549156,
      NULL,
      '10-13-1998',
      96,
      17,
      '10-24-2000',
      0,
      5.897258,
      ' 2-19-1997',
      10,
      6,
      ' 4-26-1996',
      NULL,
      1,
      12.425581,
      ' 1- 4-1993',
      43.064669,
      0,
      6.250637,
      ' 0-16-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


