set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621804';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3131',
      '42132333',
      '41132042',
      '03341042',
      '04204200',
      '30112213',
      NULL,
      '02111243',
      '32331041',
      '34000020',
      '03011012',
      '31124021',
      '02304124',
      '34322301',
      '00003004',
      '20200113',
      NULL,
      '42003341',
      NULL,
      '10131210',
      '11302334',
      '32313444',
      '03012121',
      '23231340',
      '14141130',
      '14144300',
      NULL,
      NULL,
      '22120041',
      '31024403',
      '01032011',
      '33340212',
      '04103102',
      '11010023',
      '40414204',
      '14411020',
      '12104222',
      '32021102',
      '24133004',
      '00023401',
      '41442211',
      '04022401',
      '24344010',
      '43401034',
      '31441002',
      '030',
      '02',
      NULL,
      17,
      '1441442',
      0,
      1,
      2,
      NULL,
      '003123',
      NULL,
      ' 0-22-1985',
      ' 4-16-1980',
      105.603671,
      133.928652,
      29,
      5.162791,
      6,
      NULL,
      NULL,
      NULL,
      5.560899,
      4.908322,
      NULL,
      5,
      NULL,
      0.619822,
      14.055871,
      2.793590,
      2.383402,
      14.858294,
      68,
      20,
      51.428804,
      9,
      NULL,
      0,
      1.996316,
      67.396882,
      52,
      73.237137,
      28.920006,
      58.534305,
      113,
      ' 0-14-2003',
      NULL,
      NULL,
      33.097496,
      15.924844,
      176,
      191.160494,
      ' 2-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21.165329,
      35,
      3.597313,
      NULL,
      4,
      ' 1-25-1981',
      NULL,
      0,
      8.216868,
      1.828927,
      0.429986,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1981',
      40.223856,
      68,
      73,
      36.586491,
      23,
      NULL,
      NULL,
      NULL,
      52.420965,
      66.589263,
      72,
      92,
      NULL,
      19.000054,
      11,
      11.887278,
      49,
      8,
      14.175210,
      4.669489,
      ' 1-28-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      103,
      6.637317,
      ' 6- 8-1981',
      NULL,
      NULL,
      NULL,
      1.073078,
      ' 2-22-2003',
      2,
      ' 8- 4-1996',
      13,
      NULL,
      ' 1- 3-2001',
      35,
      4.477652,
      ' 5-26-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      63.882298,
      4.671218,
      31.878969,
      ' 3- 3-1987',
      NULL,
      126.535906,
      ' 1-14-1994',
      1.095493,
      NULL,
      9,
      NULL,
      ' 6-26-1974',
      36,
      0.702082,
      91.431056,
      ' 7-25-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


