set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018757';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0222',
      '04123403',
      '03311220',
      '30023141',
      '31411240',
      NULL,
      '01300244',
      '31041014',
      '31414133',
      '01332030',
      '13111300',
      '44033404',
      NULL,
      NULL,
      '34323211',
      '12010411',
      '34004204',
      '21424122',
      '44011134',
      '40221221',
      '40010313',
      NULL,
      '04342020',
      '13124143',
      '34211423',
      '11244223',
      '24220303',
      NULL,
      '23203113',
      '30421022',
      '11100001',
      '04433304',
      '02212302',
      '43240003',
      '42114343',
      '24302203',
      '03023420',
      '04334114',
      NULL,
      '42303002',
      '42234331',
      '02211041',
      '31341201',
      '40033434',
      '04232442',
      NULL,
      '',
      NULL,
      NULL,
      '0114121',
      3,
      0,
      3,
      NULL,
      '401443',
      1.214287,
      ' 6-15-2003',
      ' 6-20-1996',
      NULL,
      NULL,
      16,
      7,
      18,
      4.737577,
      10,
      4,
      6,
      17.341750,
      40,
      16.201582,
      4,
      14.304049,
      2.813682,
      16.025133,
      13,
      1,
      53.918884,
      9.607476,
      NULL,
      5,
      76,
      0.558592,
      NULL,
      50.222307,
      NULL,
      NULL,
      168,
      NULL,
      NULL,
      ' 0-12-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.785876,
      2,
      1.805011,
      3.457186,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.193548,
      1,
      NULL,
      1.344978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-20-1995',
      NULL,
      78.872363,
      66,
      55.851090,
      64,
      45.966048,
      72.353150,
      109,
      24.438152,
      73.043936,
      27.510380,
      42,
      NULL,
      17.606056,
      18,
      24.398425,
      13,
      5,
      81.175075,
      12.229311,
      '11-27-2002',
      14.184290,
      7.154817,
      ' 9-19-1996',
      1.965430,
      NULL,
      10,
      17,
      14,
      7,
      NULL,
      NULL,
      NULL,
      29,
      3.660569,
      2,
      1.873233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 6-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.327582,
      13,
      NULL,
      ' 2- 5-1990',
      0,
      NULL,
      ' 0-13-2001',
      12,
      39,
      19.024989,
      42.735941,
      '10- 9-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      89,
      60,
      115,
      97,
      35,
      NULL,
      46,
      27.083857,
      5.168841,
      85,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      68.706288,
      5,
      2,
      101.404287,
      91,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.638304,
      0,
      120.408386,
      54,
      NULL,
      NULL,
      NULL,
      69.620205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      9.447339,
      1,
      NULL,
      30,
      17.783407,
      NULL,
      3.635081,
      49,
      71.385577,
      NULL,
      NULL,
      9,
      9.101626,
      5.522309,
      3,
      NULL,
      0.274655,
      1.873425,
      0,
      NULL,
      ' 6-18-1990',
      NULL,
      NULL,
      NULL,
      ' 0- 8-1986',
      NULL,
      ' 5-17-2003',
      NULL);
commit;
end;
/


