set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7732277';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      '1',
      '3',
      '1',
      '4',
      '3',
      '2',
      '2',
      '2',
      '3',
      NULL,
      '4',
      '0',
      '2',
      '0',
      '1',
      '1',
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      '3',
      '',
      '1',
      '',
      '1',
      '0',
      '1',
      '4',
      '3',
      '',
      '',
      '3',
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '3',
      '2',
      '4',
      '4',
      '3',
      '400',
      '31112140',
      44,
      3.155012,
      '1310314',
      2.693776,
      0,
      0,
      1,
      '130203',
      NULL,
      ' 0-16-1974',
      ' 8- 5-1974',
      70.583168,
      88.059614,
      20.355840,
      12.699273,
      NULL,
      NULL,
      45,
      5,
      10.046626,
      10.870947,
      1.310177,
      5,
      37.790752,
      20.221289,
      19,
      7,
      11,
      0.275850,
      NULL,
      0,
      20.849719,
      13,
      21,
      6,
      NULL,
      54,
      139,
      12.495881,
      105.410382,
      NULL,
      32,
      NULL,
      1,
      NULL,
      9,
      7.128055,
      71,
      153.716569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53.102207,
      NULL,
      15,
      NULL,
      13.810480,
      2,
      ' 6-20-1995',
      NULL,
      3.849321,
      45,
      NULL,
      3,
      18.231863,
      1,
      4.151199,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-13-1987',
      41.616768,
      83.230191,
      69.257014,
      56.378877,
      54.867449,
      5.344594,
      14.009216,
      2.241196,
      50.168395,
      41,
      51.678024,
      34.344802,
      ' 6- 6-1987',
      0,
      5.645859,
      NULL,
      51.032846,
      69,
      34.075063,
      4,
      ' 9- 9-1997',
      3,
      2.091878,
      ' 7- 1-1974',
      9.761687,
      12.866692,
      0.413837,
      8.085725,
      7,
      4.524769,
      3,
      8,
      1,
      59,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      ' 1-22-2002',
      12,
      ' 1-23-1976',
      3,
      NULL,
      NULL,
      115.386431,
      1.869970,
      ' 1-23-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      15.592436,
      ' 8-23-1986',
      12.412742,
      28,
      6,
      ' 1-15-1989',
      0,
      241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


