set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7509559';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2214',
      '04434140',
      '32101233',
      '13101021',
      '30012413',
      '20144034',
      '32343304',
      '20213433',
      '21010404',
      NULL,
      '24444124',
      '03010042',
      '23301234',
      '14242011',
      '03414231',
      '11201143',
      '13434243',
      '13134204',
      '43333201',
      '42122223',
      NULL,
      '22011242',
      '44400124',
      NULL,
      '34102032',
      '13424001',
      '02014212',
      '10300231',
      '20124114',
      '41324142',
      NULL,
      '13022404',
      '03444213',
      NULL,
      '41200033',
      '12041121',
      '00401032',
      '11313240',
      NULL,
      '12234233',
      '12321030',
      '10312002',
      '10201341',
      '14010111',
      '20224003',
      '124',
      '31',
      NULL,
      NULL,
      '1414233',
      NULL,
      1.792418,
      NULL,
      NULL,
      '304334',
      NULL,
      ' 7- 6-1998',
      NULL,
      142.054843,
      NULL,
      NULL,
      19,
      16,
      NULL,
      79,
      NULL,
      8,
      18.057499,
      NULL,
      16,
      36.928145,
      NULL,
      8,
      4,
      7,
      1.145332,
      NULL,
      8,
      NULL,
      NULL,
      53,
      2,
      0.759339,
      26,
      150.458762,
      3,
      142.924052,
      96,
      74.817168,
      ' 3- 6-1987',
      2,
      32,
      9,
      9,
      115,
      NULL,
      NULL,
      NULL,
      5,
      6,
      4,
      NULL,
      1.657850,
      12.730046,
      1,
      0.837035,
      0.868468,
      0.588352,
      3,
      1.468761,
      0.883953,
      1,
      0,
      1,
      0.007743,
      0,
      1.639501,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6- 4-1993',
      3,
      20.619147,
      12.217582,
      14.653335,
      28,
      3.890401,
      NULL,
      1,
      NULL,
      20.734192,
      NULL,
      1.437785,
      7,
      NULL,
      2,
      39,
      NULL,
      NULL,
      NULL,
      ' 8-15-1985',
      49,
      75,
      NULL,
      44,
      NULL,
      10,
      53.182840,
      NULL,
      60,
      37,
      39,
      91.134625,
      NULL,
      10.982583,
      24,
      25,
      NULL,
      NULL,
      NULL,
      5,
      ' 0-23-1998',
      25.440497,
      1,
      '10-11-2002',
      2.673426,
      11,
      4.399918,
      11,
      12.414627,
      4,
      1,
      4,
      1.465768,
      19.994098,
      1,
      NULL,
      5.950107,
      NULL,
      NULL,
      5.161256,
      NULL,
      2,
      ' 6- 5-2001',
      2.785393,
      NULL,
      2.111016,
      NULL,
      NULL,
      8.141190,
      ' 1-26-1990',
      NULL,
      NULL,
      NULL,
      28,
      '11-27-1996',
      26,
      NULL,
      0.681414,
      7,
      ' 6- 6-1999',
      37,
      12.227100,
      NULL,
      1,
      1.855601,
      ' 2- 0-1995',
      NULL,
      NULL,
      NULL,
      3,
      0,
      15.894934,
      '10-20-1988',
      63,
      NULL,
      7.101017,
      ' 5- 9-1983',
      2.031503,
      159.966083,
      ' 2-12-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9);
commit;
end;
/


