set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8529800';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '40111321',
      '42142332',
      '42132314',
      '40043301',
      '10002434',
      '32001342',
      '11044412',
      NULL,
      '20021331',
      NULL,
      '20334003',
      '04230012',
      NULL,
      '04303020',
      '43342122',
      '43043032',
      '02124431',
      '00310230',
      '32243011',
      NULL,
      '30401242',
      '02023114',
      '04330011',
      '10312210',
      '13331320',
      '14113314',
      NULL,
      '20333321',
      '20433321',
      '22433141',
      '00000431',
      '22423312',
      '10411323',
      '43242042',
      '31333444',
      '43402244',
      '31324320',
      '31014012',
      NULL,
      '42212401',
      '20104204',
      NULL,
      '00001334',
      '210',
      '04',
      NULL,
      NULL,
      '2344201',
      3.325788,
      NULL,
      0,
      NULL,
      '414142',
      5.928377,
      ' 5-28-1979',
      ' 0- 2-1976',
      58.961561,
      NULL,
      19.549705,
      20.884204,
      20.120253,
      NULL,
      56.397109,
      NULL,
      8,
      19,
      30.172941,
      17.199416,
      NULL,
      0,
      21.739589,
      0,
      8.541834,
      6.443035,
      12,
      8.482544,
      9,
      1.886745,
      98,
      24.797236,
      NULL,
      51,
      0,
      54.676887,
      151.119754,
      187.116377,
      29,
      ' 0-27-2002',
      34,
      6,
      15,
      8.147332,
      49.766045,
      170,
      ' 4-24-1980',
      2.423929,
      0.890069,
      2.328677,
      0.712607,
      5,
      0.867531,
      3,
      1,
      1,
      0.500270,
      NULL,
      1.475547,
      NULL,
      NULL,
      0.338005,
      0,
      0.139053,
      0.996229,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      75,
      NULL,
      NULL,
      9.476009,
      NULL,
      2.413476,
      ' 3-19-1976',
      0.341917,
      0,
      36.103882,
      0,
      NULL,
      129,
      0,
      NULL,
      NULL,
      0.353236,
      2.906518,
      106,
      ' 4- 4-1997',
      91,
      89.166290,
      NULL,
      45,
      60.573900,
      NULL,
      88,
      50,
      NULL,
      77.474085,
      65.966055,
      52.418322,
      NULL,
      1.626501,
      29,
      NULL,
      3,
      18,
      76.169961,
      6.318151,
      ' 0- 4-1978',
      NULL,
      2.064072,
      ' 0-15-1985',
      0.266084,
      NULL,
      5.971242,
      0.043297,
      13.119718,
      9,
      1,
      19.072694,
      0,
      84,
      1,
      0.434753,
      19.411417,
      10.777130,
      0.415496,
      1,
      0,
      1,
      NULL,
      NULL,
      3.987008,
      3,
      '10-20-1997',
      91,
      4.643046,
      ' 2-22-1991',
      50,
      9,
      ' 1-11-1992',
      25,
      '11-25-1977',
      20,
      ' 0-20-1999',
      2.573366,
      4.004754,
      ' 9- 5-1999',
      89.500961,
      NULL,
      NULL,
      11.970133,
      22,
      ' 5- 9-1980',
      1,
      NULL,
      ' 4- 6-1996',
      1,
      NULL,
      NULL,
      ' 3-27-1975',
      58,
      51,
      37.056293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


