set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9102329';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3401',
      NULL,
      '41142400',
      '01023014',
      NULL,
      '40434432',
      '34344133',
      '43112124',
      '44044301',
      '34304421',
      '20114224',
      '03041021',
      NULL,
      NULL,
      '11224423',
      '13402132',
      '31404034',
      '33210231',
      '44032123',
      '10130034',
      '21043022',
      NULL,
      '43033214',
      NULL,
      NULL,
      NULL,
      '10242140',
      '14103104',
      NULL,
      '01321101',
      NULL,
      NULL,
      '13344441',
      '13134412',
      '31112042',
      '33303022',
      '40021020',
      NULL,
      NULL,
      '12342413',
      NULL,
      '30102140',
      '14144412',
      '33422112',
      '23112324',
      '234',
      NULL,
      NULL,
      NULL,
      '4124302',
      1.779742,
      0.910825,
      2,
      NULL,
      '324120',
      4.882593,
      NULL,
      ' 1- 6-1999',
      NULL,
      NULL,
      41.604464,
      18,
      7.568458,
      3,
      14,
      16,
      30.869677,
      8.322934,
      10.333822,
      17.452192,
      9,
      18.363401,
      14,
      11,
      NULL,
      NULL,
      47,
      NULL,
      NULL,
      13,
      21,
      NULL,
      1,
      23.256741,
      162.102688,
      101,
      121,
      66,
      195.584161,
      NULL,
      55,
      31,
      11.920786,
      22.761067,
      0,
      3.161410,
      ' 8-25-1979',
      1.650213,
      0,
      NULL,
      NULL,
      0.624239,
      5,
      0,
      2,
      1,
      0.828396,
      NULL,
      1,
      0,
      1,
      NULL,
      0.626052,
      4,
      0.626791,
      0.532694,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-28-1983',
      96.853949,
      3,
      3.255570,
      3.066681,
      NULL,
      0,
      ' 3-27-1988',
      1,
      0.406655,
      56.849392,
      NULL,
      NULL,
      166.591807,
      0,
      0,
      7,
      0.170210,
      NULL,
      39,
      '10-13-1995',
      55,
      41,
      74.866610,
      115.884429,
      50.268659,
      NULL,
      NULL,
      6.095736,
      39,
      104.685868,
      12,
      NULL,
      ' 6-21-1985',
      27.066259,
      NULL,
      9.120908,
      NULL,
      50,
      30,
      NULL,
      ' 3- 2-1991',
      30,
      18.864417,
      NULL,
      4.607328,
      9,
      7,
      15,
      6.781090,
      11,
      0,
      14,
      0.907948,
      70.092493,
      0,
      NULL,
      2,
      11,
      2,
      1,
      1.811357,
      1.551592,
      ' 1- 0-1999',
      13.226557,
      2.453964,
      0,
      ' 3- 5-1989',
      NULL,
      1,
      ' 3- 4-1990',
      2,
      1.989986,
      ' 6-14-1984',
      23,
      ' 0-15-1996',
      50,
      NULL,
      11.133938,
      6.555917,
      ' 5-27-1989',
      96.293036,
      51.825686,
      ' 8-18-1990',
      5,
      4,
      ' 8-19-1976',
      2,
      NULL,
      ' 9- 0-1982',
      NULL,
      0,
      20,
      ' 0- 6-1991',
      4,
      20,
      35.354565,
      ' 9- 4-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.521276);
commit;
end;
/


