set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6607689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1101',
      '12430403',
      '23430004',
      NULL,
      '42131444',
      '20314231',
      '01313301',
      '01044332',
      '21410143',
      '13024144',
      NULL,
      '44220141',
      '13004401',
      '10202124',
      NULL,
      '01213433',
      NULL,
      '22114343',
      '01432232',
      '31222431',
      '31300113',
      '44024313',
      NULL,
      '33332100',
      '32424212',
      '24322444',
      NULL,
      '22222110',
      '11440100',
      '04411422',
      NULL,
      '30401423',
      '23403331',
      '03213113',
      '13441203',
      '01422033',
      '02241111',
      NULL,
      '32430123',
      '12411033',
      '11202023',
      '02322233',
      NULL,
      '14300212',
      '11343333',
      '411',
      '10',
      30.295946,
      2,
      '1211344',
      3.540700,
      1,
      1,
      NULL,
      '241222',
      5.512324,
      NULL,
      NULL,
      40,
      37.238152,
      1.059502,
      18,
      29,
      12.637502,
      14.622844,
      NULL,
      8.127856,
      4,
      23.617507,
      NULL,
      0.076696,
      10.485191,
      19,
      10,
      0,
      1,
      30,
      NULL,
      13,
      8.511333,
      36.470903,
      6.042214,
      1.262978,
      90,
      140.969054,
      34,
      18,
      113.881520,
      188.834124,
      ' 8-12-1993',
      NULL,
      26.765504,
      5.763004,
      NULL,
      5.664938,
      NULL,
      ' 7-22-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      77,
      NULL,
      0,
      21.550358,
      8.298385,
      0.984613,
      ' 3-10-1996',
      NULL,
      NULL,
      135,
      0,
      0,
      114,
      0.962080,
      0.183411,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      4.120128,
      NULL,
      42.581100,
      24,
      57.817383,
      16.440771,
      17,
      5.313473,
      NULL,
      11.110493,
      25,
      NULL,
      ' 1-14-1987',
      29.296563,
      15,
      26.687322,
      NULL,
      29,
      80,
      10.381581,
      ' 5- 1-1993',
      16,
      0.977329,
      '10-16-1993',
      NULL,
      NULL,
      27.742801,
      18,
      28.939614,
      7.782188,
      NULL,
      NULL,
      NULL,
      67,
      NULL,
      4,
      11,
      17,
      NULL,
      NULL,
      NULL,
      1,
      '10-25-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      191,
      NULL,
      ' 8- 7-1974',
      NULL,
      NULL,
      NULL,
      17.126970,
      ' 9-22-1992',
      11,
      '11-21-1980',
      15,
      NULL,
      ' 1-22-1978',
      NULL,
      122.392728,
      ' 5-16-2001',
      0,
      NULL,
      '10-10-2000',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      9,
      NULL,
      23.572605,
      NULL,
      28,
      '10-28-1979',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


