set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6607689';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1303',
      '24241042',
      NULL,
      '44430023',
      NULL,
      '04043212',
      NULL,
      '14420132',
      '33420212',
      '43042123',
      '03444341',
      '14224310',
      '00220121',
      '00232411',
      '01430442',
      '14033130',
      '00114142',
      '31414243',
      '41101241',
      '44404101',
      '12014134',
      '11242442',
      '40143202',
      '03422033',
      '01111401',
      '40422023',
      '14021023',
      '21430332',
      '10041003',
      '01413441',
      NULL,
      '01343422',
      NULL,
      NULL,
      '44230030',
      '41104421',
      '34340112',
      NULL,
      '13023003',
      '20344141',
      NULL,
      '24344110',
      '23004033',
      NULL,
      '40243400',
      '124',
      '22',
      NULL,
      2,
      '2032141',
      3.786165,
      19,
      3,
      NULL,
      '334420',
      5,
      ' 5-26-1985',
      ' 8-12-1976',
      NULL,
      4.747880,
      NULL,
      NULL,
      17.218005,
      3.028156,
      61,
      NULL,
      NULL,
      5,
      2,
      10,
      43,
      8.625394,
      7.099559,
      15.907237,
      13,
      8.064790,
      47.428638,
      NULL,
      36.574059,
      7.456837,
      0,
      NULL,
      0.940358,
      72,
      67.345931,
      46,
      NULL,
      6,
      46.566023,
      ' 5- 2-2003',
      58.068990,
      23.869599,
      NULL,
      31,
      55.444261,
      179.308745,
      ' 3- 0-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66.637502,
      6.865987,
      11,
      3.882721,
      NULL,
      9.153136,
      ' 2-14-1992',
      0.706186,
      NULL,
      201,
      3,
      NULL,
      24,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-18-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.893022,
      30.747427,
      14.200822,
      108,
      12.325038,
      24.203168,
      3,
      ' 1-19-1995',
      23.914702,
      9.256160,
      NULL,
      7.761372,
      23,
      15,
      4,
      18,
      0.240366,
      NULL,
      16,
      1.943438,
      124,
      1,
      NULL,
      2.811139,
      27,
      1.938541,
      2,
      0,
      0,
      ' 4-21-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      141.393931,
      31.919892,
      ' 6- 9-1983',
      NULL,
      NULL,
      NULL,
      45.981438,
      ' 1-29-1981',
      32,
      ' 3-14-1980',
      13.511141,
      7.598790,
      ' 1-28-1981',
      31,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      30,
      ' 3- 8-1989',
      3.027727,
      NULL,
      ' 9- 2-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


