set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9690541';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '1',
      NULL,
      '2',
      '1',
      NULL,
      '2',
      '0',
      '4',
      '4',
      '4',
      '1',
      '3',
      NULL,
      '4',
      NULL,
      '0',
      '4',
      '2',
      '4',
      '1',
      '2',
      '0',
      '',
      NULL,
      NULL,
      '4',
      '1',
      '4',
      NULL,
      '1',
      '',
      '',
      NULL,
      '4',
      NULL,
      '2',
      '1',
      '4',
      '0',
      '0',
      '1',
      '0',
      '0',
      '212',
      '33311041',
      21.292801,
      33,
      '2223310',
      0,
      NULL,
      2,
      NULL,
      '144343',
      3.022436,
      '11-21-1999',
      ' 4-26-1989',
      25,
      36,
      25.286250,
      25,
      1.430174,
      6.648662,
      36,
      1.164076,
      0.039069,
      7.539024,
      45,
      13,
      NULL,
      9,
      23.743556,
      NULL,
      20.846424,
      21,
      NULL,
      2.025338,
      NULL,
      NULL,
      142,
      16.288807,
      1.938340,
      11.259105,
      NULL,
      111,
      224.860995,
      54.644117,
      144,
      NULL,
      NULL,
      77,
      NULL,
      21.702182,
      NULL,
      186,
      ' 5-29-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.251113,
      15.792352,
      0.043903,
      5.550937,
      3,
      3,
      ' 6- 2-1981',
      0.822385,
      0.555820,
      NULL,
      0,
      3.502339,
      46.720945,
      1,
      NULL,
      92.177844,
      NULL,
      NULL,
      NULL,
      '11-20-1992',
      43,
      NULL,
      5,
      34,
      NULL,
      11,
      88.719013,
      24,
      88,
      52,
      83.286312,
      105.064442,
      '11-15-1995',
      5,
      36.398333,
      38,
      14,
      34,
      197,
      0.475798,
      ' 7-16-1990',
      10,
      19.934959,
      ' 3-11-1987',
      9,
      3,
      27.172750,
      25,
      23,
      0.288377,
      0,
      12,
      0,
      NULL,
      NULL,
      0,
      6,
      1,
      0,
      1.428067,
      0,
      1,
      ' 4- 8-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      290,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      54.508990,
      NULL,
      26,
      ' 5- 5-1988',
      NULL,
      NULL,
      NULL,
      18.552690,
      72,
      ' 9-11-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      22,
      ' 9- 5-1997',
      17.136502,
      50,
      6,
      ' 4-26-1977',
      0.099760,
      55,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


