set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '4310878';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0031',
      '42044324',
      '21124043',
      '14434431',
      '14342314',
      '23204342',
      '34443410',
      '32400323',
      '23004132',
      '00144234',
      '34303031',
      '02221444',
      '30120103',
      '23232310',
      '14032000',
      '12423240',
      '11044231',
      NULL,
      '23222244',
      '34034410',
      '40210031',
      '44420113',
      '11333140',
      '23204042',
      '04443232',
      '04221343',
      '10201112',
      NULL,
      '13311404',
      '23314010',
      '11304340',
      '30433123',
      '23402324',
      '02023101',
      '33403411',
      '31143120',
      '22212241',
      '22432242',
      '32423441',
      '22224104',
      '20123201',
      NULL,
      '13313422',
      NULL,
      NULL,
      '204',
      NULL,
      NULL,
      NULL,
      '4241104',
      2,
      0.931980,
      0,
      NULL,
      '124130',
      3,
      ' 1-18-1997',
      ' 8- 1-1996',
      85.659936,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      11,
      0.868346,
      NULL,
      NULL,
      22,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883464,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-13-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.448058,
      1,
      1,
      1.478694,
      NULL,
      0.373011,
      0.878552,
      1,
      1.308116,
      0.100146,
      1,
      0.858047,
      1.491813,
      1.020564,
      0.175991,
      1.971533,
      0.672366,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-23-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.620806,
      0,
      45.851046,
      0.392059,
      0,
      47.957794,
      4,
      5.119799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      1,
      9,
      NULL,
      32.328544,
      25.628315,
      43,
      20.063834,
      NULL,
      14.999426,
      33.332316,
      23.469434,
      ' 2- 1-1993',
      11,
      15.377359,
      5.565030,
      18.600058,
      47,
      60,
      3,
      ' 9-23-2002',
      NULL,
      NULL,
      NULL,
      4,
      8,
      8,
      0.674846,
      3,
      5.693069,
      0.515353,
      NULL,
      0.358675,
      62,
      NULL,
      1.121617,
      NULL,
      0,
      0.493055,
      NULL,
      4,
      12.571233,
      '10-13-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.247921,
      80.967583,
      ' 6-10-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


