set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8907708';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3433',
      '33102324',
      NULL,
      '12111104',
      '40433032',
      '32134003',
      NULL,
      '43344411',
      '44420141',
      '13224113',
      '02311223',
      NULL,
      '41342111',
      NULL,
      '10324113',
      '10130020',
      '21441401',
      '22101133',
      NULL,
      '42142144',
      '00440140',
      '01331001',
      '21144143',
      NULL,
      '01121201',
      '14024232',
      '14112403',
      '03133004',
      '13342044',
      NULL,
      '02111114',
      '01203220',
      NULL,
      '43030102',
      '21441012',
      NULL,
      '03314403',
      NULL,
      '23302323',
      NULL,
      '14314000',
      '23344021',
      '21230302',
      '44434412',
      '04042200',
      '300',
      '13',
      NULL,
      NULL,
      '0333240',
      1.161014,
      0.512883,
      0,
      NULL,
      '414334',
      3.703010,
      NULL,
      ' 6- 3-2001',
      21,
      NULL,
      26.134750,
      14.085643,
      27.182372,
      13,
      34.482221,
      NULL,
      3.899351,
      3.428313,
      13.199226,
      1,
      28.159687,
      1.466880,
      33.151267,
      23.589593,
      20,
      5.491151,
      NULL,
      19.262815,
      14.053322,
      24,
      11,
      28,
      1.701939,
      86.450544,
      139,
      131,
      83,
      265.006976,
      32,
      NULL,
      40,
      25,
      12,
      12.615417,
      NULL,
      123,
      ' 0-23-1977',
      0.022975,
      NULL,
      NULL,
      0.755993,
      NULL,
      0,
      1.107206,
      1,
      0.074916,
      0,
      2.872305,
      NULL,
      1,
      1,
      0.779851,
      1,
      1,
      1.595560,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8- 6-1994',
      NULL,
      NULL,
      15.242832,
      5,
      7.726851,
      1.126834,
      '11-12-2000',
      0.450327,
      1,
      66,
      1.637216,
      1,
      40,
      1,
      3,
      8.264307,
      NULL,
      NULL,
      NULL,
      NULL,
      62,
      30.388568,
      23,
      97.802956,
      24,
      NULL,
      88.743510,
      39,
      44,
      82,
      NULL,
      31,
      ' 2- 1-1995',
      NULL,
      30,
      12.773408,
      NULL,
      6,
      141.135036,
      12,
      ' 9-18-1990',
      30,
      5.684320,
      ' 4-27-1991',
      NULL,
      26,
      28,
      12.753787,
      18.125817,
      NULL,
      2,
      22.187019,
      NULL,
      64,
      0.617770,
      1,
      NULL,
      NULL,
      1,
      1.165077,
      0.004315,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '10-26-1975',
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      NULL,
      ' 8- 0-1989',
      17.683267,
      10,
      NULL,
      2.575929,
      NULL,
      ' 9- 6-1992',
      8,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      16.819932,
      ' 1-25-1983',
      44,
      8,
      NULL,
      NULL,
      0.839977,
      52,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


