set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9423680';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      '0',
      '3',
      NULL,
      NULL,
      '0',
      NULL,
      '0',
      NULL,
      '2',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      '0',
      NULL,
      '2',
      '4',
      '3',
      '3',
      '',
      NULL,
      '',
      '4',
      '4',
      '4',
      NULL,
      '3',
      '',
      '',
      '3',
      '0',
      '2',
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      '4',
      '3',
      '3',
      '420',
      NULL,
      8,
      0.872172,
      NULL,
      2.209301,
      1.398947,
      1,
      NULL,
      '042330',
      5.094520,
      ' 5- 5-1992',
      NULL,
      50.279343,
      75.516921,
      NULL,
      NULL,
      NULL,
      2.621120,
      56,
      2.510279,
      26.454943,
      3.203495,
      18,
      11.356545,
      36.744255,
      NULL,
      NULL,
      9,
      NULL,
      2.051980,
      30.281626,
      0.478598,
      27,
      15,
      NULL,
      5.662940,
      NULL,
      31.623861,
      89.262720,
      38.613619,
      110,
      202.628648,
      156,
      ' 4-22-1997',
      56,
      69.459555,
      12,
      NULL,
      99,
      200,
      '11-13-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      3.710800,
      NULL,
      9.033704,
      8,
      '11-26-1992',
      1.067666,
      1,
      239,
      1,
      1.110554,
      24.160622,
      1.270046,
      1.275991,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-12-1977',
      3.515029,
      109,
      14.545060,
      65.968646,
      NULL,
      NULL,
      8,
      88,
      37,
      NULL,
      NULL,
      NULL,
      ' 9-28-1985',
      31.382289,
      31.604030,
      13,
      NULL,
      98.512402,
      105,
      8.812945,
      ' 8-14-1999',
      NULL,
      NULL,
      ' 5-22-1991',
      12.858461,
      15,
      12.697641,
      8,
      16,
      10,
      1.360878,
      9,
      1,
      119.280722,
      1,
      NULL,
      26,
      1.068105,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54.021262,
      0.003704,
      ' 7- 3-2003',
      NULL,
      NULL,
      NULL,
      52,
      ' 5-23-2002',
      41,
      ' 9-22-1979',
      8,
      11,
      ' 6- 4-1988',
      20.446353,
      11,
      ' 7-28-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      25,
      ' 9-18-1976',
      62.620146,
      31,
      NULL,
      NULL,
      0,
      48.083243,
      ' 5-16-1991',
      10.394012,
      NULL,
      NULL,
      27,
      ' 2-18-1992',
      7,
      NULL,
      10.567478,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


