set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8710659';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      NULL,
      '0',
      '2',
      '2',
      '2',
      '3',
      '1',
      '0',
      '0',
      '4',
      '4',
      '0',
      '2',
      '1',
      '1',
      '1',
      NULL,
      '3',
      '1',
      '4',
      '4',
      '3',
      '0',
      '',
      '0',
      '',
      '0',
      '1',
      '2',
      NULL,
      '3',
      '',
      '',
      '1',
      '0',
      '2',
      '0',
      '2',
      NULL,
      NULL,
      NULL,
      '1',
      '1',
      '2',
      '304',
      '23314414',
      29.286628,
      23.759418,
      '0300343',
      3,
      1.067703,
      NULL,
      1,
      NULL,
      5.989876,
      NULL,
      ' 1-28-1991',
      298.532983,
      92,
      34.704776,
      25,
      48,
      28,
      117,
      33,
      36.107620,
      NULL,
      12.853647,
      14.453442,
      NULL,
      NULL,
      35.475877,
      24,
      0.667820,
      1.357162,
      86,
      NULL,
      NULL,
      8.026689,
      139,
      4.189612,
      0,
      4.654206,
      14,
      11.584713,
      198.450690,
      262,
      252,
      '10- 8-1996',
      46,
      67,
      NULL,
      34.092398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.928643,
      11.972787,
      5.191425,
      3,
      13,
      6.888191,
      ' 0- 8-1995',
      0.879734,
      2.983704,
      135,
      NULL,
      NULL,
      61,
      1,
      2,
      46,
      NULL,
      NULL,
      NULL,
      '11- 8-1985',
      36,
      36.634321,
      NULL,
      119.849543,
      10.326816,
      7.121557,
      132,
      9.367933,
      16,
      57,
      109.414247,
      7.390429,
      ' 7-19-2001',
      34.995623,
      NULL,
      43,
      101,
      58,
      168,
      10.976390,
      '10- 7-1997',
      14.177057,
      NULL,
      NULL,
      5.644468,
      0.606253,
      NULL,
      6.292557,
      10,
      8,
      0,
      NULL,
      1,
      NULL,
      3.702031,
      1,
      24,
      NULL,
      NULL,
      1,
      1.184727,
      1.952431,
      ' 3- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      154.900511,
      NULL,
      ' 2-18-1991',
      NULL,
      NULL,
      NULL,
      47.466419,
      ' 5-27-1996',
      17.556976,
      ' 9-26-1988',
      17.353560,
      15,
      '11-12-1976',
      51.998950,
      NULL,
      ' 2-10-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      4,
      ' 2-21-2001',
      NULL,
      62.998390,
      33,
      ' 3- 3-1979',
      1.056382,
      19.101292,
      ' 7-14-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


