set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8908405';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0133',
      '24013013',
      '22433040',
      '40133301',
      '12342430',
      '03430014',
      '41141210',
      '40242140',
      '30311400',
      '14423133',
      NULL,
      '42204404',
      '01303234',
      NULL,
      '01001301',
      '42321144',
      '34423310',
      '14230112',
      '01313322',
      '42231300',
      '33023202',
      '11341314',
      NULL,
      '43123344',
      NULL,
      '42200311',
      '20140204',
      '12203422',
      '40412032',
      '43242444',
      '32240420',
      NULL,
      '14401303',
      '10414430',
      '13244441',
      '22243043',
      '31341004',
      '22010200',
      '23402220',
      '32041422',
      NULL,
      '00424210',
      '34431421',
      '02121201',
      '02241111',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      3.581437,
      0,
      1,
      NULL,
      '230033',
      1,
      ' 3- 1-1989',
      NULL,
      20.986405,
      NULL,
      7,
      8,
      12,
      8.427520,
      32.315215,
      16,
      17.696874,
      3,
      10.502306,
      11,
      1,
      2,
      6.513588,
      5.740921,
      3,
      1.855098,
      10.318317,
      5.320225,
      51.922268,
      18.711454,
      NULL,
      2.694013,
      NULL,
      22.867118,
      62.232923,
      32.913790,
      NULL,
      NULL,
      32,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      65.382067,
      84.572923,
      33,
      NULL,
      63,
      80,
      45.424444,
      NULL,
      '11-28-1984',
      2.756463,
      NULL,
      NULL,
      NULL,
      36.928728,
      6,
      0,
      ' 9- 8-1976',
      1,
      NULL,
      ' 4- 1-1978',
      0,
      NULL,
      NULL,
      1,
      3,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1.149561,
      1.218185,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-15-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448943,
      163,
      ' 8-21-1989',
      7,
      25,
      NULL,
      NULL,
      NULL,
      30,
      0.275645,
      163,
      '10-11-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264073,
      4.773089,
      33.514549,
      NULL,
      NULL,
      NULL,
      0,
      11.560539,
      82.943071,
      NULL,
      NULL,
      3,
      NULL,
      3.528555,
      NULL,
      NULL,
      NULL,
      0.475656,
      1,
      1.956140,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      20.257222,
      0.959787,
      5,
      0,
      NULL,
      1.750420,
      NULL,
      NULL,
      NULL,
      ' 2-28-1979',
      NULL,
      NULL,
      ' 4-14-1990',
      NULL,
      ' 4-16-2003',
      NULL);
commit;
end;
/


