set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0421',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '40012124',
      '44011102',
      '44342044',
      '31213020',
      '20010144',
      '33122242',
      '12300310',
      '12040331',
      '21233122',
      '22332101',
      NULL,
      '01130013',
      '22420303',
      '10411101',
      '30211210',
      '33131342',
      '32320200',
      '24021421',
      '40342302',
      '34214140',
      '44401304',
      '41343244',
      '43003412',
      '43133232',
      '01320300',
      NULL,
      '44241102',
      '13233434',
      '33021330',
      NULL,
      '22003202',
      '12410404',
      NULL,
      '24240432',
      '40123004',
      NULL,
      NULL,
      '23313220',
      '43022321',
      NULL,
      NULL,
      NULL,
      NULL,
      '4211110',
      3.926515,
      0.677381,
      2,
      NULL,
      '330234',
      5.730130,
      ' 5- 9-2000',
      ' 8-27-1974',
      24,
      NULL,
      22.020836,
      17.123867,
      14.480970,
      NULL,
      10,
      15.457870,
      24.705391,
      14.693133,
      38,
      2,
      32,
      NULL,
      11,
      20,
      NULL,
      9,
      4,
      14.596844,
      39.410513,
      NULL,
      62,
      7,
      0.695941,
      18.718055,
      NULL,
      13.983371,
      164,
      171,
      71,
      ' 6-15-1996',
      34.332509,
      29,
      4,
      NULL,
      42.023014,
      61.305933,
      ' 8-29-1983',
      NULL,
      5.128722,
      1.924700,
      2,
      3.966950,
      1,
      1.463671,
      2,
      0.988955,
      0,
      3.417029,
      1.653168,
      NULL,
      6.356188,
      1.829288,
      NULL,
      1.427451,
      0.585026,
      NULL,
      1.201242,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-28-1974',
      44.028771,
      20.837303,
      7,
      16.531198,
      7.970353,
      7,
      '11-21-2000',
      1,
      1,
      88.366619,
      1.487570,
      3,
      101,
      1,
      0.350620,
      37,
      NULL,
      NULL,
      NULL,
      ' 6- 2-1983',
      96,
      21.278745,
      NULL,
      61,
      43.769342,
      1.224203,
      NULL,
      86,
      29.594513,
      24,
      NULL,
      56.348742,
      ' 7- 3-1995',
      6.874521,
      18,
      2.605167,
      NULL,
      51,
      8.720940,
      0,
      ' 1-22-1998',
      1.890554,
      11,
      ' 4-19-1978',
      NULL,
      NULL,
      NULL,
      9,
      14.640030,
      9,
      0.450340,
      NULL,
      1.765731,
      62.469328,
      0,
      1,
      NULL,
      9.131884,
      NULL,
      NULL,
      0,
      1.334109,
      ' 3-14-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      48.416728,
      NULL,
      ' 8- 5-2003',
      NULL,
      NULL,
      NULL,
      5,
      ' 4-10-1985',
      NULL,
      ' 4- 2-1982',
      NULL,
      16,
      NULL,
      113,
      NULL,
      ' 5-13-1996',
      0.307224,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5.032655,
      ' 4-25-1993',
      36.537939,
      24,
      NULL,
      NULL,
      1.035269,
      37,
      ' 2- 9-1998',
      5.614717,
      48,
      NULL,
      71.760082,
      NULL,
      55.658292,
      NULL,
      111.018101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


