set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2343',
      NULL,
      '31040424',
      '10443240',
      NULL,
      '22034013',
      '01322213',
      NULL,
      '41344223',
      '31124011',
      '10201011',
      '22021134',
      NULL,
      '33311422',
      '02213323',
      '40123010',
      NULL,
      '02241213',
      '33141241',
      NULL,
      '04133013',
      '33342332',
      NULL,
      NULL,
      '32243133',
      '41131401',
      NULL,
      '33134124',
      '40344101',
      '24442330',
      NULL,
      '42404322',
      '13003112',
      '33314211',
      '12111212',
      '43320243',
      '42114131',
      '22421311',
      '01423431',
      '43414041',
      NULL,
      '32331402',
      NULL,
      NULL,
      NULL,
      '032',
      NULL,
      16.885980,
      11,
      '3402344',
      NULL,
      44.283406,
      3,
      NULL,
      '341000',
      1,
      ' 5- 2-1984',
      ' 7- 0-2000',
      61,
      95,
      NULL,
      3.356140,
      NULL,
      3,
      NULL,
      NULL,
      17,
      4.572357,
      NULL,
      19,
      39,
      16,
      NULL,
      2,
      23.797158,
      NULL,
      9.859586,
      18.600992,
      9.977982,
      0.675946,
      43.247484,
      8.228204,
      NULL,
      95,
      144,
      18.250822,
      120.273647,
      131.070717,
      27,
      NULL,
      35,
      3.913092,
      NULL,
      21.118168,
      84,
      203,
      ' 8-21-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      31,
      23,
      8,
      8.832628,
      NULL,
      ' 7-13-1987',
      0,
      NULL,
      85.537347,
      1.369961,
      NULL,
      112,
      1.471875,
      0,
      43,
      NULL,
      NULL,
      NULL,
      NULL,
      67.819844,
      104,
      65,
      32,
      95.054328,
      90.142519,
      NULL,
      106.994491,
      45.384767,
      7.901597,
      59,
      100,
      ' 3-12-1978',
      18,
      16.687534,
      0,
      NULL,
      16,
      32.327538,
      9.434463,
      ' 9- 4-1999',
      20.617067,
      19,
      ' 1-29-1978',
      0.372114,
      17.951313,
      7.879867,
      7,
      6.140772,
      3.324618,
      1.780732,
      NULL,
      NULL,
      NULL,
      5.337881,
      NULL,
      9,
      17.257771,
      1.082237,
      8.498319,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.617385,
      0.326029,
      ' 1- 8-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 1-2002',
      25.210033,
      ' 6- 3-1984',
      4.463801,
      16,
      ' 9-29-1979',
      135.993875,
      28.829135,
      '10-14-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.952699,
      ' 9-25-1979',
      18.910064,
      17,
      18.602897,
      ' 5- 7-1977',
      1.541483,
      90.394635,
      NULL,
      NULL,
      NULL,
      6,
      32,
      ' 5-12-1978',
      17,
      NULL,
      80,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


