set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      '2',
      '2',
      '0',
      '4',
      '3',
      '2',
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      '4',
      NULL,
      '1',
      NULL,
      '0',
      NULL,
      '3',
      NULL,
      '1',
      '2',
      '0',
      '',
      '3',
      '',
      NULL,
      '4',
      '2',
      '0',
      '0',
      '',
      '',
      '3',
      NULL,
      '0',
      NULL,
      '3',
      '0',
      '0',
      NULL,
      NULL,
      '2',
      NULL,
      '014',
      NULL,
      16.693926,
      27.853969,
      '0011442',
      0.106394,
      37.527451,
      NULL,
      NULL,
      '421344',
      NULL,
      '10-23-1982',
      ' 3-28-1986',
      NULL,
      NULL,
      1,
      NULL,
      11,
      5,
      4.730530,
      13.864076,
      4,
      2,
      NULL,
      NULL,
      24.161971,
      4.813605,
      NULL,
      14,
      NULL,
      4.356319,
      19.139608,
      8,
      44.207527,
      6.766856,
      55,
      7.471109,
      1.744633,
      5.716479,
      172.079997,
      36.279799,
      134.145685,
      NULL,
      87,
      ' 3-19-1996',
      26.165593,
      16.031038,
      18.945870,
      24.982679,
      85.428302,
      42.350139,
      '11- 5-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61.442009,
      NULL,
      NULL,
      2.777646,
      NULL,
      2,
      ' 1- 5-1997',
      0,
      0,
      41,
      0.291836,
      0,
      NULL,
      1,
      5,
      36,
      NULL,
      NULL,
      NULL,
      ' 8-20-1974',
      90,
      NULL,
      49.308683,
      47,
      25,
      7.367206,
      65.613889,
      3.351895,
      NULL,
      55.592078,
      26.931575,
      68.581245,
      ' 9-15-1978',
      14.781171,
      2,
      9.757614,
      15.095714,
      NULL,
      9,
      3.810828,
      ' 3-19-1984',
      8.987006,
      10,
      ' 6- 9-1991',
      5,
      NULL,
      8.845158,
      13.550330,
      2,
      2,
      0.837122,
      4.929198,
      1.168835,
      60,
      0,
      2.159373,
      11.439459,
      15,
      2.696154,
      NULL,
      NULL,
      NULL,
      ' 5-11-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      7.823309,
      ' 9-16-1998',
      NULL,
      NULL,
      NULL,
      43.719377,
      ' 0-15-2000',
      25,
      NULL,
      6.907685,
      8,
      ' 3- 9-1977',
      8,
      55,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      2.054726,
      NULL,
      33,
      8,
      7,
      ' 4-17-1997',
      NULL,
      393,
      NULL,
      10.114829,
      20,
      8,
      39,
      ' 6-12-2000',
      22.885031,
      0.350522,
      40,
      '11- 6-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


