set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8326935';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      NULL,
      '1',
      '3',
      '1',
      '4',
      '3',
      NULL,
      '1',
      '0',
      '3',
      '2',
      '1',
      '4',
      NULL,
      '2',
      '1',
      '4',
      '0',
      '4',
      '2',
      NULL,
      '4',
      '',
      '3',
      '',
      '3',
      '1',
      '0',
      '2',
      NULL,
      '',
      '',
      NULL,
      '0',
      '3',
      '2',
      '4',
      '4',
      '1',
      NULL,
      NULL,
      '1',
      '2',
      '302',
      NULL,
      17,
      30,
      NULL,
      1,
      54.002108,
      0,
      0,
      '234402',
      1.121662,
      ' 0- 8-1992',
      '11-17-1997',
      NULL,
      NULL,
      34,
      15.941226,
      NULL,
      4.474018,
      56.741226,
      0,
      17.626745,
      2,
      NULL,
      NULL,
      8,
      5.036567,
      10.791492,
      1.536457,
      17,
      17.060966,
      31.479670,
      NULL,
      5.181215,
      NULL,
      52,
      5,
      NULL,
      68.514599,
      156,
      9.195634,
      94,
      51.652946,
      72,
      '10- 6-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47.636525,
      19.210375,
      7,
      22.510666,
      NULL,
      0,
      ' 6- 6-1997',
      NULL,
      0.733277,
      NULL,
      1.747206,
      1,
      61.757808,
      0.453586,
      NULL,
      52,
      NULL,
      NULL,
      NULL,
      NULL,
      73.426019,
      88.823399,
      82,
      1.681935,
      44,
      82.863946,
      6.195309,
      38,
      47,
      5.552008,
      NULL,
      NULL,
      ' 1-25-1996',
      NULL,
      19,
      0,
      21.324830,
      17.882670,
      10,
      NULL,
      ' 9- 3-1978',
      NULL,
      NULL,
      NULL,
      0,
      3,
      7.136431,
      10,
      11.142696,
      1.389421,
      0,
      5,
      3.892722,
      16.639715,
      1,
      NULL,
      5.783294,
      7,
      NULL,
      NULL,
      1,
      0.270914,
      ' 2- 2-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      4.398868,
      NULL,
      ' 1-17-1983',
      NULL,
      NULL,
      NULL,
      29,
      ' 7-16-2000',
      38.962174,
      NULL,
      NULL,
      8,
      ' 4- 7-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      6,
      ' 5-22-1998',
      15,
      11,
      10,
      ' 5-20-1991',
      4.457464,
      NULL,
      ' 6- 8-1982',
      14,
      90,
      6.259227,
      57,
      ' 2-21-1987',
      48.130606,
      NULL,
      101.032811,
      ' 7-12-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


